/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.helpers;

import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHTMLElement
implements CharSequence,
Appendable {
    private String name;
    private CharSequence body;
    private SortedMap<Object, String> attributes;

    protected AbstractHTMLElement(String string, String string2, String string3) {
        this.name = string;
        this.body = string3;
        this.attributes = new TreeMap<Object, String>();
        if (string2 != null) {
            this.setId(string2);
        }
    }

    protected AbstractHTMLElement(String string) {
        this(string, null);
    }

    protected AbstractHTMLElement(String string, String string2) {
        this(string, string2, null);
    }

    protected final SortedMap<Object, String> getAttributes() {
        return this.attributes;
    }

    protected final String getName() {
        return this.name;
    }

    public final String getBody() {
        return this.body == null ? "" : ((Object)this.body).toString();
    }

    public final void setBody(CharSequence charSequence) {
        this.body = charSequence;
    }

    public final String getClassName() {
        return (String)this.attributes.get((Object)HTMLAttribute.CLASS);
    }

    public final void setClassName(String string) {
        this.attributes.put((Object)HTMLAttribute.CLASS, string);
    }

    public final String getId() {
        return (String)this.attributes.get((Object)HTMLAttribute.ID);
    }

    public final void setId(String string) {
        this.attributes.put((Object)HTMLAttribute.ID, string);
    }

    @Override
    public final int length() {
        return this.toString().length();
    }

    @Override
    public final char charAt(int n) {
        return this.toString().charAt(n);
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return this.toString().subSequence(n, n2);
    }

    protected void cleanAttributes() {
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder("<");
        stringBuilder.append(this.getName());
        this.cleanAttributes();
        for (Map.Entry<Object, String> entry : this.getAttributes().entrySet()) {
            String string = StringUtils.trimToNull((String)entry.getValue());
            if (string == null) continue;
            stringBuilder.append(' ').append(entry.getKey().toString().toLowerCase(Locale.getDefault())).append("=\"");
            stringBuilder.append(string.replaceAll("\"", "\\\"")).append('\"');
        }
        stringBuilder.append('>');
        stringBuilder.append(this.getBody());
        stringBuilder.append("</").append(this.getName()).append('>');
        return stringBuilder.toString();
    }

    @Override
    public final AbstractHTMLElement append(CharSequence charSequence) {
        this.setBody(this.getBody() + charSequence);
        return this;
    }

    @Override
    public final AbstractHTMLElement append(char c) {
        return this.append(String.valueOf(c));
    }

    @Override
    public final AbstractHTMLElement append(CharSequence charSequence, int n, int n2) {
        return this.append(charSequence.subSequence(n, n2));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTMLAttribute {
        CLASS,
        ID,
        HREF,
        TITLE;

    }
}

