/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.helpers;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private static final String TRANSFORMER_YES = "yes";
    private static final ThreadLocal<TransformerFactory> TRANSFORMER_FACTORY = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    private static final ThreadLocal<DocumentBuilderFactory> DOC_FACTORY = new ThreadLocal<DocumentBuilderFactory>(){

        @Override
        protected DocumentBuilderFactory initialValue() {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            return documentBuilderFactory;
        }
    };
    private static final ThreadLocal<XPathFactory> XPATH_FACTORY = new ThreadLocal<XPathFactory>(){

        @Override
        protected XPathFactory initialValue() {
            return XPathFactory.newInstance();
        }
    };

    private XMLUtils() {
    }

    public static NodeList evaluateXPathExpression(String string, Node node) throws XPathExpressionException {
        return (NodeList)XMLUtils.evaluateXPathExpression(string, node, XPathConstants.NODESET);
    }

    public static Object evaluateXPathExpression(String string, Node node, QName qName) throws XPathExpressionException {
        return XMLUtils.getNewXPath().evaluate(string, node, qName == null ? XPathConstants.NODE : qName);
    }

    public static XPath getNewXPath() {
        return XPATH_FACTORY.get().newXPath();
    }

    private static DocumentBuilder getNewDocumentBuilder() throws ParserConfigurationException {
        return DOC_FACTORY.get().newDocumentBuilder();
    }

    public static Document getXMLDocument(String string) throws SAXException {
        try {
            return XMLUtils.getNewDocumentBuilder().parse(new InputSource(new StringReader(string)));
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    public static Document createDocument() throws ParserConfigurationException {
        return XMLUtils.getNewDocumentBuilder().newDocument();
    }

    public static String format(String string) throws TransformerException, SAXException {
        return XMLUtils.toString(XMLUtils.getXMLDocument(string));
    }

    public static String toString(Document document) throws TransformerException {
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        Transformer transformer = TRANSFORMER_FACTORY.get().newTransformer();
        transformer.setOutputProperty("indent", TRANSFORMER_YES);
        transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", TRANSFORMER_YES);
        transformer.transform(new DOMSource(document.getDocumentElement()), streamResult);
        return stringWriter.toString();
    }

    protected static boolean isCharInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    protected static boolean isValidHtmlNameStartChar(int n) {
        return XMLUtils.isCharInRange(n, 65, 90) || XMLUtils.isCharInRange(n, 97, 122);
    }

    protected static boolean isValidHtmlNameChar(int n) {
        return XMLUtils.isValidXmlNameStartChar(n) || XMLUtils.isCharInRange(n, 48, 57) || n == 45 || n == 95 || n == 58 || n == 46;
    }

    protected static boolean isValidXmlNameStartChar(int n) {
        return n == 58 || XMLUtils.isCharInRange(n, 65, 90) || n == 95 || XMLUtils.isCharInRange(n, 97, 122) || XMLUtils.isCharInRange(n, 192, 214) || XMLUtils.isCharInRange(n, 216, 246) || XMLUtils.isCharInRange(n, 248, 767) || XMLUtils.isCharInRange(n, 880, 893) || XMLUtils.isCharInRange(n, 895, 8191) || XMLUtils.isCharInRange(n, 8204, 8205) || XMLUtils.isCharInRange(n, 8304, 8591) || XMLUtils.isCharInRange(n, 11264, 12271) || XMLUtils.isCharInRange(n, 12289, 55295) || XMLUtils.isCharInRange(n, 63744, 64975) || XMLUtils.isCharInRange(n, 65008, 65533) || XMLUtils.isCharInRange(n, 65536, 983039);
    }

    protected static boolean isValidXmlNameChar(int n) {
        return XMLUtils.isValidXmlNameStartChar(n) || n == 45 || n == 46 || XMLUtils.isCharInRange(n, 48, 57) || n == 183 || XMLUtils.isCharInRange(n, 768, 879) || XMLUtils.isCharInRange(n, 8255, 8256);
    }

    public static boolean isValidHtmlName(String string) {
        if (string == null) {
            return true;
        }
        if (!XMLUtils.isValidHtmlNameStartChar(string.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XMLUtils.isValidHtmlNameChar(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidXmlName(String string) {
        if (string == null) {
            return true;
        }
        if (!XMLUtils.isValidXmlNameStartChar(string.codePointAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XMLUtils.isValidXmlNameChar(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }
}

