/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.servlets;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.ajaxtags.servlets.BaseAjaxXmlAction;
import org.apache.commons.lang.NotImplementedException;

public final class AjaxActionHelper {
    private AjaxActionHelper() {
    }

    public static String invoke(BaseAjaxXmlAction baseAjaxXmlAction, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException {
        try {
            httpServletRequest.setCharacterEncoding(baseAjaxXmlAction.getXMLEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new ServletException((Throwable)unsupportedEncodingException);
        }
        httpServletResponse.setContentType("text/xml; charset=" + baseAjaxXmlAction.getXMLEncoding());
        for (HTMLAjaxHeader hTMLAjaxHeader : HTMLAjaxHeader.values()) {
            hTMLAjaxHeader.enable(httpServletResponse);
        }
        try {
            return baseAjaxXmlAction.getXmlContent(httpServletRequest, httpServletResponse);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HTMLAjaxHeader {
        CACHE_CONTROL("Cache-Control", "no-store, max-age=0, no-cache, must-revalidate, post-check=0, pre-check=0"),
        PRAGMA("Pragma", "no-cache");

        private String headerName;
        private String headerValue;

        private HTMLAjaxHeader(String string2, String string3) {
            this.headerName = string2;
            this.headerValue = string3;
        }

        public void enable(HttpServletResponse httpServletResponse) {
            httpServletResponse.setHeader(this.headerName, this.headerValue);
        }

        public void disable(HttpServletResponse httpServletResponse) {
            throw new NotImplementedException("This is not implemented yet.");
        }
    }
}

