/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.tags;

import javax.servlet.jsp.JspException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import net.sourceforge.ajaxtags.helpers.XMLUtils;
import net.sourceforge.ajaxtags.tags.BaseAjaxBodyTag;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AjaxAnchorsTag
extends BaseAjaxBodyTag {
    private static final long serialVersionUID = -1732745741282114289L;
    private static final String WARP0 = "<div>";
    private static final String WARP1 = "</div>";

    public int doEndTag() throws JspException {
        this.out(this.processBody());
        return 6;
    }

    public String processBody() throws JspException {
        String string = this.getBody();
        try {
            return this.processContent(string);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new JspException(((Object)((Object)this)).getClass().getSimpleName() + ": rewrite links failed (wrong XPath expression)\n" + string, (Throwable)xPathExpressionException);
        }
        catch (TransformerException transformerException) {
            throw new JspException(((Object)((Object)this)).getClass().getSimpleName() + ": rewrite links failed (cannot transform XHTML to text)\n" + string, (Throwable)transformerException);
        }
        catch (SAXException sAXException) {
            throw new JspException(((Object)((Object)this)).getClass().getSimpleName() + ": rewrite links failed (invalid XHTML content)\n" + string, (Throwable)sAXException);
        }
    }

    protected String processContent(String string) throws XPathExpressionException, TransformerException, SAXException {
        return this.rewriteAnchors(string, this.getTarget(), this.getSourceClass());
    }

    protected String rewriteAnchors(String string, String string2, String string3) throws XPathExpressionException, TransformerException, SAXException {
        Document document = AjaxAnchorsTag.getDocument(string);
        NodeList nodeList = XMLUtils.evaluateXPathExpression(AjaxAnchorsTag.getAnchorXPath(string3), document);
        this.rewriteLinks(nodeList, string2);
        return XMLUtils.toString(document);
    }

    private static String getAnchorXPath(String string) {
        return string == null ? "//a" : "//a[@class=\"" + string + "\"]";
    }

    protected void rewriteLinks(NodeList nodeList, String string) {
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            this.rewriteLink(nodeList.item(i), string);
        }
    }

    protected final void rewriteLink(Node node, String string) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Attr attr = (Attr)namedNodeMap.getNamedItem("href");
        if (attr != null) {
            Attr attr2 = (Attr)namedNodeMap.getNamedItem("onclick");
            if (attr2 == null) {
                attr2 = node.getOwnerDocument().createAttribute("onclick");
                namedNodeMap.setNamedItem(attr2);
            }
            attr2.setValue(this.getOnclickAjax(string, attr.getValue(), this.getOptionsBuilder()));
            attr.setValue("javascript://nop/");
        }
    }

    protected static final Document getDocument(String string) throws SAXException {
        String string2 = StringUtils.trimToNull((String)string);
        return string2 == null ? null : XMLUtils.getXMLDocument(WARP0 + string2 + WARP1);
    }
}

