/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.tags;

import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import net.sourceforge.ajaxtags.helpers.XMLUtils;
import net.sourceforge.ajaxtags.tags.AjaxAreaTag;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AjaxDisplayTag
extends AjaxAreaTag {
    private static final long serialVersionUID = -5945152631578965550L;
    private String pagelinksClass;
    private String columnClass;

    public AjaxDisplayTag() {
        this.init();
    }

    private void init() {
        this.pagelinksClass = "pagelinks";
        this.columnClass = "sortable";
    }

    public String getPagelinksClass() {
        return this.pagelinksClass;
    }

    public void setPagelinksClass(String string) {
        this.pagelinksClass = StringUtils.trimToNull((String)string);
    }

    public String getColumnClass() {
        return this.columnClass;
    }

    public void setColumnClass(String string) {
        this.columnClass = StringUtils.trimToNull((String)string);
    }

    public void releaseTag() {
        super.releaseTag();
        this.init();
    }

    protected String processContent(String string) throws TransformerException, SAXException, XPathExpressionException {
        return this.rewriteAnchors(string, this.getId());
    }

    protected String rewriteAnchors(String string, String string2) throws TransformerException, SAXException, XPathExpressionException {
        Document document = AjaxDisplayTag.getDocument(string);
        NodeList nodeList = AjaxDisplayTag.findRewritableLinksFor(document, "span", this.getPagelinksClass());
        this.rewriteLinks(nodeList, string2);
        NodeList nodeList2 = AjaxDisplayTag.findRewritableLinksFor(document, "th", this.getColumnClass());
        this.rewriteLinks(nodeList2, string2);
        return XMLUtils.toString(document);
    }

    private static NodeList findRewritableLinksFor(Document document, String string, String string2) throws XPathExpressionException {
        return XMLUtils.evaluateXPathExpression(AjaxDisplayTag.getAnchorXPath(string, string2), document);
    }

    private static String getAnchorXPath(String string, String string2) {
        return string2 == null ? "//" + string + "/a" : "//" + string + "[@class=\"" + string2 + "\" or contains(concat(' ',@class,' '),' " + string2 + " ')]/a";
    }

    protected String rewriteAnchors(String string, String string2, String string3) {
        throw new UnsupportedOperationException("This method should never be called. Use rewriteAnchors(String, String) instead.");
    }
}

