/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.tags;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.JspException;
import net.sourceforge.ajaxtags.helpers.HTMLAnchorElement;
import net.sourceforge.ajaxtags.helpers.HTMLDivElement;
import net.sourceforge.ajaxtags.helpers.HTMLLIElement;
import net.sourceforge.ajaxtags.helpers.HTMLUListElement;
import net.sourceforge.ajaxtags.tags.AjaxTabPageTag;
import net.sourceforge.ajaxtags.tags.BaseAjaxBodyTag;
import net.sourceforge.ajaxtags.tags.OptionsBuilder;
import org.apache.commons.lang.StringUtils;

public class AjaxTabPanelTag
extends BaseAjaxBodyTag {
    private static final long serialVersionUID = 4008240512963947567L;
    private static final char PAGES_DELIMITER = ',';
    private String contentId;
    private List<String> pages = new ArrayList<String>();
    private List<HTMLLIElement> listItems = new ArrayList<HTMLLIElement>();

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String string) {
        this.contentId = string;
    }

    protected void initParameters() throws JspException {
        this.pages = new ArrayList<String>();
        this.listItems = new ArrayList<HTMLLIElement>();
    }

    protected String getJsClass() {
        return "AjaxJspTag.TabPanel";
    }

    protected OptionsBuilder getOptions() {
        OptionsBuilder optionsBuilder = this.getOptionsBuilder();
        optionsBuilder.add("id", this.getId(), true);
        optionsBuilder.add("contentId", this.getContentId(), true);
        optionsBuilder.add("pages", this.getPages(), false);
        return optionsBuilder;
    }

    public int doEndTag() throws JspException {
        if (this.pages.isEmpty()) {
            throw new JspException("No tabs added to tab panel.");
        }
        HTMLDivElement hTMLDivElement = new HTMLDivElement(this.getId());
        hTMLDivElement.setClassName(this.getStyleClass() == null ? "tabPanel" : this.getStyleClass() + " tabPanel");
        HTMLDivElement hTMLDivElement2 = new HTMLDivElement();
        hTMLDivElement2.setClassName("tabNavigation");
        HTMLUListElement hTMLUListElement = new HTMLUListElement();
        hTMLUListElement.setBody(this.getListItems());
        hTMLDivElement.append(hTMLDivElement2.append(hTMLUListElement));
        hTMLDivElement.append(this.buildScript());
        this.out(hTMLDivElement);
        return 6;
    }

    public void releaseTag() {
        this.pages = null;
        this.listItems = null;
    }

    public final void addPage(AjaxTabPageTag ajaxTabPageTag) {
        this.pages.add(ajaxTabPageTag.toString());
        HTMLAnchorElement hTMLAnchorElement = new HTMLAnchorElement(ajaxTabPageTag.getBaseUrl());
        hTMLAnchorElement.setBody(ajaxTabPageTag.getCaption());
        HTMLLIElement hTMLLIElement = new HTMLLIElement();
        hTMLLIElement.setId(ajaxTabPageTag.getId());
        hTMLLIElement.append(hTMLAnchorElement);
        this.listItems.add(hTMLLIElement);
    }

    protected String getListItems() {
        return StringUtils.join(this.listItems, (String)"");
    }

    protected String getPages() {
        return '[' + StringUtils.join(this.pages, (char)',') + ']';
    }
}

