/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.tags;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import net.sourceforge.ajaxtags.helpers.JavaScript;
import net.sourceforge.ajaxtags.servlets.AjaxActionHelper;
import net.sourceforge.ajaxtags.tags.OptionsBuilder;
import org.apache.commons.lang.StringUtils;

public abstract class BaseAjaxBodyTag
extends BodyTagSupport {
    public static final String TARGET_HEADER = "X-Request-Target";
    public static final String HEADER_FLAG = "X-Requested-With";
    public static final String HEADER_FLAG_VALUE = "XMLHttpRequest";
    public static final String AJAX_VOID_URL = "javascript://nop";
    public static final String JSCLASS_BASE = "AjaxJspTag.";
    private static final long serialVersionUID = 2128368408391947139L;
    private boolean skipBody;
    private String styleClass;
    private String source;
    private String target;
    private String baseUrl;
    private String parser;
    private String parameters;
    private String preFunction;
    private String postFunction;
    private String errorFunction;
    private String var;
    private String attachTo;
    private String sourceClass;
    private String eventType;

    protected HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)this.pageContext.getRequest();
    }

    protected HttpServletResponse getHttpServletResponse() {
        return (HttpServletResponse)this.pageContext.getResponse();
    }

    protected boolean isHttpRequestHeader(String string, String string2) {
        return string2.equalsIgnoreCase(this.getHttpRequestHeader(string));
    }

    protected String getHttpRequestHeader(String string) {
        return this.getHttpServletRequest().getHeader(string);
    }

    protected boolean isAjaxRequest() {
        return this.isHttpRequestHeader(HEADER_FLAG, HEADER_FLAG_VALUE);
    }

    protected boolean isRequestTarget(String string) {
        return this.isHttpRequestHeader(TARGET_HEADER, string);
    }

    protected void out(CharSequence charSequence) throws JspException {
        try {
            this.pageContext.getOut().append(charSequence);
        }
        catch (IOException iOException) {
            throw new JspException((Throwable)iOException);
        }
    }

    protected final void skipBody() {
        this.skipBody = true;
    }

    public void setId(String string) {
        if (string != null) {
            // empty if block
        }
        super.setId(string);
    }

    public final int doStartTag() throws JspException {
        this.initParameters();
        for (AjaxActionHelper.HTMLAjaxHeader hTMLAjaxHeader : AjaxActionHelper.HTMLAjaxHeader.values()) {
            hTMLAjaxHeader.enable(this.getHttpServletResponse());
        }
        return this.skipBody ? 0 : 2;
    }

    public final void release() {
        this.setId(null);
        this.target = null;
        this.baseUrl = null;
        this.parser = null;
        this.preFunction = null;
        this.postFunction = null;
        this.errorFunction = null;
        this.parameters = null;
        this.var = null;
        this.attachTo = null;
        this.source = null;
        this.sourceClass = null;
        this.eventType = null;
        this.styleClass = null;
        this.releaseTag();
    }

    public final String getEventType() {
        return this.eventType;
    }

    public final void setEventType(String string) {
        this.eventType = StringUtils.trimToNull((String)string);
    }

    public final String getSourceClass() {
        return this.sourceClass;
    }

    public final void setSourceClass(String string) {
        this.sourceClass = StringUtils.trimToNull((String)string);
    }

    public final String getSource() {
        return this.source;
    }

    public final void setSource(String string) {
        this.source = StringUtils.trimToNull((String)string);
    }

    public final String getVar() {
        return this.var;
    }

    public final void setVar(String string) {
        this.var = StringUtils.trimToNull((String)string);
    }

    public final void setAttachTo(String string) {
        this.attachTo = StringUtils.trimToNull((String)string);
    }

    public final String getAttachTo() {
        return this.attachTo;
    }

    public final String getStyleClass() {
        return this.styleClass;
    }

    public final void setStyleClass(String string) {
        this.styleClass = StringUtils.trimToNull((String)string);
    }

    public final String getJSVariable() {
        if (this.var == null) {
            return "";
        }
        return this.attachTo == null ? "var " + this.var + " = " : this.attachTo + "." + this.var + " = ";
    }

    protected String getJsClass() {
        throw new UnsupportedOperationException("You must implement getJsClass() in your tag class to use buildScript().");
    }

    protected OptionsBuilder getOptions() {
        return this.getOptionsBuilder();
    }

    public JavaScript buildScript() {
        return new JavaScript(this.getJSVariable() + "new " + this.getJsClass() + "({" + this.getOptions() + "});");
    }

    public final String getParameters() {
        return this.parameters;
    }

    public final void setParameters(String string) {
        this.parameters = StringUtils.trimToNull((String)string);
    }

    public final String getErrorFunction() {
        return this.errorFunction;
    }

    public final void setErrorFunction(String string) {
        this.errorFunction = StringUtils.trimToNull((String)string);
    }

    public final String getPostFunction() {
        return this.postFunction;
    }

    public final void setPostFunction(String string) {
        this.postFunction = StringUtils.trimToNull((String)string);
    }

    public final String getPreFunction() {
        return this.preFunction;
    }

    public final void setPreFunction(String string) {
        this.preFunction = StringUtils.trimToNull((String)string);
    }

    public final String getParser() {
        return this.parser;
    }

    public final void setParser(String string) {
        this.parser = StringUtils.trimToNull((String)string);
    }

    public final String getBaseUrl() {
        return this.baseUrl;
    }

    public final void setBaseUrl(String string) {
        this.baseUrl = StringUtils.trimToNull((String)string);
    }

    public final String getTarget() {
        return this.target;
    }

    public final void setTarget(String string) {
        this.target = StringUtils.trimToNull((String)string);
    }

    protected void initParameters() throws JspException {
    }

    protected void releaseTag() {
    }

    protected OptionsBuilder getOptionsBuilder() {
        return this.getOptionsBuilder(false);
    }

    protected OptionsBuilder getOptionsBuilder(boolean bl) {
        OptionsBuilder optionsBuilder = OptionsBuilder.getOptionsBuilder();
        if (bl) {
            return optionsBuilder;
        }
        optionsBuilder.add("baseUrl", this.getBaseUrl(), true);
        optionsBuilder.add("parser", this.getParser(), false);
        optionsBuilder.add("target", this.getTarget(), true);
        optionsBuilder.add("source", this.getSource(), true);
        optionsBuilder.add("sourceClass", this.getSourceClass(), true);
        optionsBuilder.add("eventType", this.getEventType(), true);
        optionsBuilder.add("parameters", this.getParameters(), true);
        optionsBuilder.add("onCreate", this.preFunction, false);
        optionsBuilder.add("onComplete", this.postFunction, false);
        optionsBuilder.add("onFailure", this.errorFunction, false);
        return optionsBuilder;
    }

    protected final String getOnclickAjax(String string, String string2, OptionsBuilder optionsBuilder) {
        OptionsBuilder optionsBuilder2 = OptionsBuilder.getOptionsBuilder(optionsBuilder);
        optionsBuilder2.add("target", string, true);
        optionsBuilder2.add("baseUrl", string2, true);
        optionsBuilder2.add("eventBase", "this", false);
        optionsBuilder2.add("requestHeaders", "['X-Request-Target', '" + string + "']", false);
        StringBuilder stringBuilder = new StringBuilder("new AjaxJspTag.OnClick({");
        stringBuilder.append(optionsBuilder2.toString());
        stringBuilder.append("}); return false;");
        return stringBuilder.toString();
    }

    protected String getBody() {
        BodyContent bodyContent = this.getBodyContent();
        return bodyContent == null ? null : bodyContent.getString();
    }
}

