/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.tags;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;

public final class OptionsBuilder {
    private String optionsDelimiter = ", ";
    private final SortedMap<String, String> parameters = new TreeMap<String, String>();

    private OptionsBuilder() {
    }

    private OptionsBuilder(OptionsBuilder optionsBuilder) {
        if (optionsBuilder != null) {
            this.parameters.putAll(optionsBuilder.parameters);
        }
    }

    public static OptionsBuilder getOptionsBuilder(OptionsBuilder optionsBuilder) {
        return new OptionsBuilder(optionsBuilder);
    }

    public static OptionsBuilder getOptionsBuilder() {
        return OptionsBuilder.getOptionsBuilder(null);
    }

    public String getOptionsDelimiter() {
        return this.optionsDelimiter;
    }

    public void setOptionsDelimiter(String string) {
        this.optionsDelimiter = StringUtils.defaultString((String)string);
    }

    public OptionsBuilder add(String string, boolean bl) {
        return this.add(string, String.valueOf(bl), false);
    }

    public OptionsBuilder add(String string, int n) {
        return this.add(string, String.valueOf(n), false);
    }

    public OptionsBuilder add(String string, String string2, boolean bl) {
        if (string2 != null && !this.parameters.containsKey(string)) {
            if (bl) {
                this.parameters.put(string, '\"' + string2 + '\"');
            } else {
                this.parameters.put(string, string2);
            }
        }
        return this;
    }

    public OptionsBuilder add(String string, String string2, boolean bl, boolean bl2) {
        if (this.parameters.containsKey(string)) {
            this.parameters.remove(string);
        }
        return this.add(string, string2, bl);
    }

    public OptionsBuilder remove(String string) {
        this.parameters.remove(string);
        return this;
    }

    public String toString() {
        int n = this.parameters.size();
        if (n < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(n * 20);
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(this.optionsDelimiter);
            }
            stringBuilder.append(entry.getKey()).append(": ").append(entry.getValue());
        }
        return stringBuilder.toString();
    }
}

