/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.ajaxtags.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sourceforge.ajaxtags.helpers.TreeItem;
import net.sourceforge.ajaxtags.xml.BaseXmlBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AjaxTreeXmlBuilder
extends BaseXmlBuilder<TreeItem> {
    public AjaxTreeXmlBuilder addItem(String string, String string2) {
        return this.addItem(string, string2, null);
    }

    public AjaxTreeXmlBuilder addItemAsCData(String string, String string2) {
        return this.addItemAsCData(string, string2, null);
    }

    public AjaxTreeXmlBuilder addItemAsCData(String string, String string2, Map<String, String> map) {
        return this.addItem(string, string2, true, map);
    }

    public AjaxTreeXmlBuilder addItem(String string, String string2, Map<String, String> map) {
        return this.addItem(string, string2, false, map);
    }

    public AjaxTreeXmlBuilder addItem(String string, String string2, boolean bl, Map<?, String> map) {
        this.getList().add(new TreeItem(string, string2, bl, map));
        return this;
    }

    public AjaxTreeXmlBuilder addItem(String string, String string2, String string3, boolean bl) {
        return this.addItem(string, string2, false, string3, bl);
    }

    public AjaxTreeXmlBuilder addItem(String string, String string2, boolean bl, String string3) {
        return this.addItem(string, string2, bl, string3, false);
    }

    public AjaxTreeXmlBuilder addItem(String string, String string2, boolean bl, String string3, boolean bl2) {
        HashMap<TreeItem.TreeAttribute, String> hashMap = new HashMap<TreeItem.TreeAttribute, String>();
        hashMap.put(TreeItem.TreeAttribute.URL, string3);
        hashMap.put(TreeItem.TreeAttribute.COLLAPSED, String.valueOf(bl));
        return this.addItem(string, string2, bl2, hashMap);
    }

    public AjaxTreeXmlBuilder addItemAsCData(String string, String string2, boolean bl, String string3) {
        HashMap<TreeItem.TreeAttribute, String> hashMap = new HashMap<TreeItem.TreeAttribute, String>();
        hashMap.put(TreeItem.TreeAttribute.URL, string3);
        hashMap.put(TreeItem.TreeAttribute.COLLAPSED, String.valueOf(bl));
        return this.addItem(string, string2, true, hashMap);
    }

    public AjaxTreeXmlBuilder addItems(Collection<PropertyReader> collection) {
        for (PropertyReader propertyReader : collection) {
            this.addItem(propertyReader);
        }
        return this;
    }

    public AjaxTreeXmlBuilder addItem(PropertyReader propertyReader) {
        HashMap<TreeItem.TreeAttribute, String> hashMap = new HashMap<TreeItem.TreeAttribute, String>();
        hashMap.put(TreeItem.TreeAttribute.URL, propertyReader.getURL());
        hashMap.put(TreeItem.TreeAttribute.COLLAPSED, String.valueOf(propertyReader.isCollapsed()));
        hashMap.put(TreeItem.TreeAttribute.LEAF, String.valueOf(propertyReader.isLeaf()));
        this.addItem(propertyReader.getName(), propertyReader.getValue(), propertyReader.isCData(), hashMap);
        return this;
    }

    @Override
    protected String getXMLString() {
        StringBuilder stringBuilder = new StringBuilder("<ajax-response><response>");
        for (TreeItem treeItem : this.getItems()) {
            stringBuilder.append("<item><name>");
            if (treeItem.isAsCData()) {
                stringBuilder.append("<![CDATA[");
            }
            stringBuilder.append(treeItem.getName());
            if (treeItem.isAsCData()) {
                stringBuilder.append("]]>");
            }
            stringBuilder.append("</name><value>");
            if (treeItem.isAsCData()) {
                stringBuilder.append("<![CDATA[");
            }
            stringBuilder.append(treeItem.getValue());
            if (treeItem.isAsCData()) {
                stringBuilder.append("]]>");
            }
            stringBuilder.append("</value>");
            for (Object object : treeItem.getAttributeKeySet()) {
                String string = object.toString().toLowerCase(Locale.getDefault());
                stringBuilder.append('<').append(string).append('>');
                stringBuilder.append(treeItem.getAttributeValue(object));
                stringBuilder.append("</").append(string).append('>');
            }
            stringBuilder.append("</item>");
        }
        stringBuilder.append("</response></ajax-response>");
        return stringBuilder.toString();
    }

    public static interface PropertyReader {
        public String getName();

        public boolean isCollapsed();

        public String getURL();

        public boolean isLeaf();

        public String getValue();

        public boolean isCData();
    }
}

