/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import cubrid.jdbc.driver.CUBRIDPreparedStatement;
import cubrid.jdbc.jci.UStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDCallableStatement
extends CUBRIDPreparedStatement
implements CallableStatement {
    private boolean was_null;

    protected CUBRIDCallableStatement(CUBRIDConnection cUBRIDConnection, UStatement uStatement) {
        super(cUBRIDConnection, uStatement, 1003, 1007, 2);
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkIsOpen();
        return this.was_null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n) throws SQLException {
        int n2;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            n2 = this.u_stmt.getInt(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n) throws SQLException {
        Object object;
        this.checkIsOpen();
        this.beforeGetValue(n);
        Object object2 = this.u_stmt;
        synchronized (object2) {
            object = this.u_stmt.getObject(n);
            this.error = this.u_stmt.getRecentError();
        }
        if (object != null && object instanceof Clob) {
            object2 = (Clob)object;
            int n2 = object2.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)object2.length();
            return object2.getSubString(1L, n2);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            object2 = this.u_stmt.getString(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n) throws SQLException {
        boolean bl;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            bl = this.u_stmt.getBoolean(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n) throws SQLException {
        byte by;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            by = this.u_stmt.getByte(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return by;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n) throws SQLException {
        short s;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            s = this.u_stmt.getShort(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n) throws SQLException {
        long l;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            l = this.u_stmt.getLong(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n) throws SQLException {
        float f;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            f = this.u_stmt.getFloat(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n) throws SQLException {
        double d;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            d = this.u_stmt.getDouble(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n) throws SQLException {
        Object object;
        this.checkIsOpen();
        this.beforeGetValue(n);
        Object object2 = this.u_stmt;
        synchronized (object2) {
            object = this.u_stmt.getObject(n);
            this.error = this.u_stmt.getRecentError();
        }
        if (object != null && object instanceof Blob) {
            object2 = (Blob)object;
            int n2 = object2.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)object2.length();
            return object2.getBytes(1L, n2);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            object2 = this.u_stmt.getBytes(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n) throws SQLException {
        Date date;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            date = this.u_stmt.getDate(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n) throws SQLException {
        Time time;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            time = this.u_stmt.getTime(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            timestamp = this.u_stmt.getTimestamp(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n) throws SQLException {
        Object object;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            object = this.u_stmt.getObject(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            bigDecimal = this.u_stmt.getBigDecimal(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n) throws SQLException {
        CUBRIDBlob cUBRIDBlob;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            cUBRIDBlob = this.u_stmt.getBlob(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return cUBRIDBlob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n) throws SQLException {
        CUBRIDClob cUBRIDClob;
        this.checkIsOpen();
        this.beforeGetValue(n);
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            cUBRIDClob = this.u_stmt.getClob(n);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkGetXXXError();
        return cUBRIDClob;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this.getDate(n);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this.getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this.getTimestamp(n);
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setByte(String string, byte by) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setShort(String string, short s) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInt(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(String string, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFloat(String string, float f) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(String string, double d) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String string, Date date) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String string, Time time) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String string, Object object, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(String string, Object object) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(String string, int n, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte getByte(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(int n, int n2) throws SQLException {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n);
    }

    @Override
    public void registerOutParameter(String string, int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String string, int n, int n2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerOutParameter(String string, int n, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerOutParameter(int n) throws SQLException {
        this.checkIsOpen();
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.registerOutParameter(n - 1);
            this.error = this.u_stmt.getRecentError();
        }
        this.checkBindError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void beforeGetValue(int n) throws SQLException {
        if (n < 0 || n > this.u_stmt.getParameterCount()) {
            throw this.con.createCUBRIDException(CUBRIDJDBCErrorCode.invalid_index);
        }
        UStatement uStatement = this.u_stmt;
        synchronized (uStatement) {
            this.u_stmt.fetch();
            this.error = this.u_stmt.getRecentError();
        }
        switch (this.error.getErrorCode()) {
            case 0: {
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    void checkGetXXXError() throws SQLException {
        switch (this.error.getErrorCode()) {
            case 0: {
                this.was_null = false;
                break;
            }
            case 8: {
                this.was_null = true;
                break;
            }
            default: {
                throw this.con.createCUBRIDException(this.error);
            }
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

