/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

class CUBRIDClobOutputStream
extends OutputStream {
    private CUBRIDClob clob;
    private long lob_pos;

    CUBRIDClobOutputStream(CUBRIDClob cUBRIDClob, long l) {
        this.clob = cUBRIDClob;
        this.lob_pos = l;
    }

    public synchronized void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.lob_pos += (long)this.clob.setBytes(this.lob_pos, byArray, n, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.clob.removeFlushableStream(this);
        this.clob = null;
    }
}

