/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDClob;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

class CUBRIDClobReader
extends Reader {
    private CUBRIDClob clob;
    private long char_pos;
    private long char_length;

    CUBRIDClobReader(CUBRIDClob cUBRIDClob, long l, long l2) {
        this.clob = cUBRIDClob;
        this.char_pos = l;
        this.char_length = l - 1L + l2;
        if (this.char_length < 0L) {
            this.char_length = Long.MAX_VALUE;
        }
    }

    public synchronized int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == 1) {
            return 0xFFFF & cArray[0];
        }
        return -1;
    }

    public synchronized int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public synchronized int read(char[] cArray, int n, int n2) throws IOException {
        int n3;
        if (this.clob == null) {
            return -1;
        }
        if (cArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (this.char_pos - 1L + (long)n2 > this.char_length && (n2 = (int)(this.char_length - this.char_pos + 1L)) < 0) {
                n2 = 0;
            }
            String string = this.clob.getSubString(this.char_pos, n2);
            string.getChars(0, string.length(), cArray, n);
            n3 = string.length();
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
        this.char_pos += (long)n3;
        if (n3 < n2 || this.char_pos > this.char_length) {
            this.clob = null;
        }
        return n3;
    }

    public synchronized void close() throws IOException {
        this.clob = null;
    }
}

