/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnectionEventListener;
import cubrid.jdbc.driver.CUBRIDConnectionPoolDataSource;
import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;

abstract class CUBRIDConnectionPoolManager {
    private static Hashtable connectionPooltable = new Hashtable();
    private static Hashtable poolDataSourceTable = new Hashtable();

    CUBRIDConnectionPoolManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Connection getConnection(CUBRIDConnectionPoolDataSource cUBRIDConnectionPoolDataSource, String string, String string2) throws SQLException {
        CUBRIDConnectionEventListener cUBRIDConnectionEventListener;
        String string3 = cUBRIDConnectionPoolDataSource.getDataSourceID(string);
        Hashtable hashtable = connectionPooltable;
        synchronized (hashtable) {
            cUBRIDConnectionEventListener = (CUBRIDConnectionEventListener)connectionPooltable.get(string3);
            if (cUBRIDConnectionEventListener == null) {
                cUBRIDConnectionEventListener = CUBRIDConnectionPoolManager.addConnectionPool(string3, cUBRIDConnectionPoolDataSource);
            }
        }
        return cUBRIDConnectionEventListener.getConnection(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static CUBRIDConnectionPoolDataSource getConnectionPoolDataSource(String string) throws SQLException {
        CUBRIDConnectionPoolDataSource cUBRIDConnectionPoolDataSource;
        Hashtable hashtable = poolDataSourceTable;
        synchronized (hashtable) {
            cUBRIDConnectionPoolDataSource = (CUBRIDConnectionPoolDataSource)poolDataSourceTable.get(string);
            if (cUBRIDConnectionPoolDataSource == null) {
                try {
                    InitialContext initialContext = new InitialContext();
                    cUBRIDConnectionPoolDataSource = (CUBRIDConnectionPoolDataSource)initialContext.lookup(string);
                }
                catch (NamingException namingException) {
                    throw new CUBRIDException(CUBRIDJDBCErrorCode.unknown, namingException.toString());
                }
                poolDataSourceTable.put(string, cUBRIDConnectionPoolDataSource);
            }
        }
        return cUBRIDConnectionPoolDataSource;
    }

    private static CUBRIDConnectionEventListener addConnectionPool(String string, CUBRIDConnectionPoolDataSource cUBRIDConnectionPoolDataSource) {
        CUBRIDConnectionEventListener cUBRIDConnectionEventListener = new CUBRIDConnectionEventListener(cUBRIDConnectionPoolDataSource);
        connectionPooltable.put(string, cUBRIDConnectionEventListener);
        return cUBRIDConnectionEventListener;
    }
}

