/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDConnection;
import cubrid.jdbc.driver.CUBRIDConnectionPoolDataSource;
import cubrid.jdbc.driver.CUBRIDConnectionPoolManager;
import cubrid.jdbc.driver.CUBRIDDataSourceBase;
import cubrid.jdbc.jci.UConnection;
import cubrid.jdbc.jci.UJCIManager;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CUBRIDDataSource
extends CUBRIDDataSourceBase
implements DataSource,
Referenceable,
Serializable {
    public CUBRIDDataSource() {
    }

    protected CUBRIDDataSource(Reference reference) {
        this.setProperties(reference);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        Connection connection;
        String string3 = this.getDataSourceName();
        if (string3 == null || string3.length() == 0) {
            if (string == null) {
                string = this.getUser();
            }
            if (string2 == null) {
                string2 = this.getPassword();
            }
            UConnection uConnection = UJCIManager.connect(this.getServerName(), this.getPortNumber(), this.getDatabaseName(), string, string2, this.getDataSourceID(string));
            this.writeLog("getConnection(" + string + ")");
            connection = new CUBRIDConnection(uConnection, null, string);
        } else {
            CUBRIDConnectionPoolDataSource cUBRIDConnectionPoolDataSource = CUBRIDConnectionPoolManager.getConnectionPoolDataSource(string3);
            if (string == null) {
                string = cUBRIDConnectionPoolDataSource.getUser();
            }
            if (string2 == null) {
                string2 = cUBRIDConnectionPoolDataSource.getPassword();
            }
            connection = CUBRIDConnectionPoolManager.getConnection(cUBRIDConnectionPoolDataSource, string, string2);
        }
        return connection;
    }

    @Override
    public synchronized Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), "cubrid.jdbc.driver.CUBRIDDataSourceObjectFactory", null);
        reference = this.getProperties(reference);
        this.writeLog("Bind DataSource");
        return reference;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Logger getParentLogger() {
        throw new UnsupportedOperationException();
    }
}

