/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import java.io.IOException;
import java.io.InputStream;

class CUBRIDInputStream
extends InputStream {
    private int position;
    private byte[] valueBuffer;

    CUBRIDInputStream(byte[] byArray) {
        this.valueBuffer = byArray;
        this.position = 0;
    }

    public synchronized int available() throws IOException {
        if (this.valueBuffer == null) {
            return 0;
        }
        return this.valueBuffer.length - this.position;
    }

    public synchronized int read() throws IOException {
        byte[] byArray = new byte[1];
        if (this.read(byArray, 0, 1) == -1) {
            return -1;
        }
        return byArray[0];
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        if (this.valueBuffer == null) {
            return -1;
        }
        for (n3 = this.position; n3 < n2 + this.position && n3 < this.valueBuffer.length; ++n3) {
            byArray[n3 - this.position + n] = this.valueBuffer[n3];
        }
        int n4 = this.position;
        this.position = n3;
        if (this.position == this.valueBuffer.length) {
            this.close();
        }
        return n3 - n4;
    }

    public synchronized void close() throws IOException {
        this.valueBuffer = null;
    }
}

