/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

public class CUBRIDLobHandle {
    private int lobType;
    private long lobSize;
    private byte[] packedLobHandle;
    private String locator;

    public CUBRIDLobHandle(int n, byte[] byArray) {
        this.lobType = n;
        this.packedLobHandle = byArray;
        this.initLob();
    }

    private void initLob() {
        int n;
        int n2 = 0;
        if (this.packedLobHandle == null) {
            throw new NullPointerException();
        }
        this.lobSize = 0L;
        for (n = n2 += 4; n < n2 + 8; ++n) {
            this.lobSize <<= 8;
            this.lobSize |= (long)(this.packedLobHandle[n] & 0xFF);
        }
        n = 0;
        for (int i = n2 += 8; i < n2 + 4; ++i) {
            n <<= 8;
            n |= this.packedLobHandle[i] & 0xFF;
        }
        this.locator = new String(this.packedLobHandle, n2 += 4, n - 1);
    }

    public void setLobSize(long l) {
        int n = 0;
        if (this.packedLobHandle == null) {
            throw new NullPointerException();
        }
        this.lobSize = l;
        int n2 = 64;
        for (int i = n += 4; i < n + 8; ++i) {
            this.packedLobHandle[i] = (byte)(this.lobSize >>> (n2 -= 8) & 0xFFL);
        }
    }

    public long getLobSize() {
        return this.lobSize;
    }

    public byte[] getPackedLobHandle() {
        return this.packedLobHandle;
    }

    public String toString() {
        return this.locator;
    }

    public boolean equals(Object object) {
        if (object instanceof CUBRIDLobHandle) {
            CUBRIDLobHandle cUBRIDLobHandle = (CUBRIDLobHandle)object;
            return this.lobType == cUBRIDLobHandle.lobType && this.lobSize == cUBRIDLobHandle.lobSize && this.locator.equals(cUBRIDLobHandle.locator);
        }
        return false;
    }
}

