/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.driver;

import cubrid.jdbc.driver.CUBRIDException;
import cubrid.jdbc.driver.CUBRIDJDBCErrorCode;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionProperties {
    static ArrayList<Field> PROPERTY_LIST = new ArrayList();
    BooleanConnectionProperty logOnException = new BooleanConnectionProperty("logOnException", false);
    BooleanConnectionProperty logSlowQueries = new BooleanConnectionProperty("logSlowQueries", false);
    IntegerConnectionProperty slowQueryThresholdMillis = new IntegerConnectionProperty("slowQueryThresholdMillis", (Object)60000, 0, Integer.MAX_VALUE);
    StringConnectionProperty logFile = new StringConnectionProperty("logFile", "cubrid_jdbc.log");
    CharSetConnectionProperty charSet = new CharSetConnectionProperty("charSet", System.getProperty("file.encoding"));
    IntegerConnectionProperty rcTime = new IntegerConnectionProperty("rcTime", (Object)600, 0, Integer.MAX_VALUE);
    IntegerConnectionProperty queryTimeout = new IntegerConnectionProperty("queryTimeout", (Object)-1, -1, Integer.MAX_VALUE);
    IntegerConnectionProperty connectTimeout = new IntegerConnectionProperty("connectTimeout", (Object)this.getDefaultConnectTimeout(), -1, Integer.MAX_VALUE);
    StringConnectionProperty altHosts = new StringConnectionProperty("altHosts", null);
    ZeroDateTimeBehaviorConnectionProperty zeroDateTimeBehavior = new ZeroDateTimeBehaviorConnectionProperty("zeroDateTimeBehavior", "exception");

    public void setProperties(String string) throws SQLException {
        if (string == null) {
            return;
        }
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "?&;");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "=");
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string3 = stringTokenizer2.nextToken().toLowerCase();
            if (!stringTokenizer2.hasMoreTokens()) continue;
            String string4 = stringTokenizer2.nextToken();
            properties.put(string3, string4);
        }
        this.setProperties(properties);
    }

    public void setProperties(Properties properties) throws SQLException {
        if (properties == null) {
            return;
        }
        int n = PROPERTY_LIST.size();
        for (int i = 0; i < n; ++i) {
            Field field = PROPERTY_LIST.get(i);
            try {
                ConnectionProperty connectionProperty = (ConnectionProperty)field.get(this);
                String string = connectionProperty.getPropertyName().toLowerCase();
                String string2 = properties.getProperty(string);
                if (string2 == null) {
                    string = connectionProperty.getPropertyName();
                    string2 = properties.getProperty(string);
                }
                if (string2 == null) continue;
                connectionProperty.setValue(string2);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, " illegal access properties");
            }
        }
    }

    private int getDefaultConnectTimeout() {
        int n = DriverManager.getLoginTimeout();
        return n > 0 ? n : -1;
    }

    public boolean getLogOnException() {
        return this.logOnException.getValueAsBoolean();
    }

    public boolean getLogSlowQueris() {
        return this.logSlowQueries.getValueAsBoolean();
    }

    public int getSlowQueryThresholdMillis() {
        return this.slowQueryThresholdMillis.getValueAsInteger();
    }

    public String getLogFile() {
        return this.logFile.getValueAsString();
    }

    public String getCharSet() {
        return this.charSet.getValueAsString();
    }

    public int getReconnectTime() {
        return this.rcTime.getValueAsInteger();
    }

    public int getQueryTimeout() {
        return this.queryTimeout.getValueAsInteger();
    }

    public int getConnectTimeout() {
        return this.connectTimeout.getValueAsInteger();
    }

    public String getAltHosts() {
        return this.altHosts.getValueAsString();
    }

    public String getZeroDateTimeBehavior() {
        return this.zeroDateTimeBehavior.getValueAsString();
    }

    static {
        try {
            Field[] fieldArray = ConnectionProperties.class.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                if (!ConnectionProperty.class.isAssignableFrom(fieldArray[i].getType())) continue;
                PROPERTY_LIST.add(fieldArray[i]);
            }
        }
        catch (Exception exception) {
            RuntimeException runtimeException = new RuntimeException();
            runtimeException.initCause(exception);
            throw runtimeException;
        }
    }

    class ZeroDateTimeBehaviorConnectionProperty
    extends StringConnectionProperty {
        ZeroDateTimeBehaviorConnectionProperty(String string, Object object) {
            super(string, object);
        }

        boolean validateValue(Object object) {
            String string;
            return object instanceof String && ((string = (String)object).equals("convertToNull") || string.equals("exception") || string.equals("round"));
        }
    }

    class CharSetConnectionProperty
    extends StringConnectionProperty {
        CharSetConnectionProperty(String string, Object object) {
            super(string, object);
        }

        String getValueAsString() {
            if (this.valueAsObject == null) {
                return System.getProperty("file.encoding");
            }
            return (String)this.valueAsObject;
        }

        boolean validateValue(Object object) {
            if (object instanceof String) {
                try {
                    byte[] byArray = new byte[]{0};
                    new String(byArray, (String)object);
                    return true;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return false;
                }
            }
            return false;
        }
    }

    class StringConnectionProperty
    extends ConnectionProperty {
        StringConnectionProperty(String string, Object object) {
            super(string, object, 0L, 0L);
        }

        String getValueAsString() {
            return (String)this.valueAsObject;
        }

        boolean validateValue(Object object) {
            return object != null;
        }
    }

    class LongConnectionProperty
    extends ConnectionProperty {
        LongConnectionProperty(String string, Object object, long l, long l2) {
            super(string, object, l, l2);
        }

        long getValueAsLong() {
            if (this.valueAsObject instanceof String) {
                this.valueAsObject = Long.valueOf((String)this.valueAsObject);
            }
            return (Long)this.valueAsObject;
        }

        boolean validateValue(Object object) {
            if (object instanceof Long || object instanceof Integer) {
                return true;
            }
            if (object instanceof String) {
                try {
                    Long.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class IntegerConnectionProperty
    extends ConnectionProperty {
        IntegerConnectionProperty(String string, Object object, int n, int n2) {
            super(string, object, n, n2);
        }

        int getValueAsInteger() {
            if (this.valueAsObject instanceof String) {
                this.valueAsObject = Integer.valueOf((String)this.valueAsObject);
            }
            return (Integer)this.valueAsObject;
        }

        boolean validateValue(Object object) {
            if (object instanceof Integer) {
                return true;
            }
            if (object instanceof String) {
                try {
                    Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
                return true;
            }
            return false;
        }
    }

    class BooleanConnectionProperty
    extends ConnectionProperty {
        String[] allowableValues;

        BooleanConnectionProperty(String string, Object object) {
            super(string, object, 0L, 0L);
            this.allowableValues = new String[]{"true", "false", "yes", "no", "on", "off"};
        }

        boolean getValueAsBoolean() {
            if (this.valueAsObject instanceof String) {
                this.valueAsObject = Boolean.valueOf((String)this.valueAsObject);
            }
            return (Boolean)this.valueAsObject;
        }

        boolean validateValue(Object object) {
            if (object instanceof Boolean) {
                return true;
            }
            if (object instanceof String) {
                for (int i = 0; i < this.allowableValues.length; ++i) {
                    if (!this.allowableValues[i].equalsIgnoreCase((String)object)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    abstract class ConnectionProperty {
        String propertyName;
        Object defaultValue;
        Object valueAsObject;
        long lowerBound;
        long upperBound;

        public ConnectionProperty() {
        }

        ConnectionProperty(String string, Object object, long l, long l2) {
            this.propertyName = string;
            this.defaultValue = object;
            this.valueAsObject = object;
            this.lowerBound = l;
            this.upperBound = l2;
        }

        abstract boolean validateValue(Object var1);

        Object getValueAsObject() {
            return this.valueAsObject;
        }

        void setValue(Object object) throws SQLException {
            if (!this.validateValue(object)) {
                throw new CUBRIDException(CUBRIDJDBCErrorCode.invalid_url, " '" + object + "' uncompitable value for the " + this.propertyName);
            }
            this.valueAsObject = object;
        }

        String getPropertyName() {
            return this.propertyName;
        }
    }
}

