/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.jci.UError;
import cubrid.jdbc.jci.UErrorCode;

public class UJciException
extends Exception {
    private static final long serialVersionUID = 4464106407657785825L;
    private int jciErrCode;
    private int serverErrCode;
    private int serverErrIndicator;

    public UJciException(int n) {
        this.jciErrCode = n;
    }

    public UJciException(int n, Throwable throwable) {
        this.jciErrCode = n;
        this.setStackTrace(throwable.getStackTrace());
    }

    public UJciException(int n, int n2, int n3, String string) {
        super(string);
        this.jciErrCode = n;
        this.serverErrCode = n3;
        if (this.serverErrCode <= -10000) {
            this.serverErrCode = -10000 - this.serverErrCode;
        }
        this.serverErrIndicator = n2;
    }

    void toUError(UError uError) {
        if (this.jciErrCode == 2) {
            String string = this.serverErrIndicator == -2 ? this.getMessage() : UErrorCode.codeToCASMessage(this.serverErrCode);
            uError.setDBError(this.serverErrCode, string);
        } else if (this.jciErrCode == 23) {
            uError.setErrorMessage(this.jciErrCode, this.getMessage());
        } else {
            uError.setErrorCode(this.jciErrCode);
        }
    }

    public int getJciError() {
        return this.jciErrCode;
    }

    public String toString() {
        String string;
        String string2;
        if (this.jciErrCode == 2) {
            if (this.serverErrIndicator == -2) {
                string2 = this.getMessage();
                string = "ER_DBMS";
            } else {
                string2 = UErrorCode.codeToCASMessage(this.serverErrCode);
                string = "ER_BROKER";
            }
        } else {
            string2 = this.getMessage();
            string = "ER_DRIVER";
        }
        return String.format("%s[%d,%s]", string, this.jciErrCode, string2);
    }
}

