/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.jci;

import cubrid.jdbc.driver.CUBRIDBlob;
import cubrid.jdbc.driver.CUBRIDClob;
import cubrid.sql.CUBRIDOID;
import cubrid.sql.CUBRIDTimestamp;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

public abstract class UUType {
    public static final int U_TYPE_MIN = 0;
    public static final int U_TYPE_MAX = 24;
    public static final byte U_TYPE_NULL = 0;
    public static final byte U_TYPE_CHAR = 1;
    public static final byte U_TYPE_STRING = 2;
    public static final byte U_TYPE_VARCHAR = 2;
    public static final byte U_TYPE_NCHAR = 3;
    public static final byte U_TYPE_VARNCHAR = 4;
    public static final byte U_TYPE_BIT = 5;
    public static final byte U_TYPE_VARBIT = 6;
    public static final byte U_TYPE_NUMERIC = 7;
    public static final byte U_TYPE_DECIMAL = 7;
    public static final byte U_TYPE_INT = 8;
    public static final byte U_TYPE_SHORT = 9;
    public static final byte U_TYPE_MONETARY = 10;
    public static final byte U_TYPE_FLOAT = 11;
    public static final byte U_TYPE_DOUBLE = 12;
    public static final byte U_TYPE_DATE = 13;
    public static final byte U_TYPE_TIME = 14;
    public static final byte U_TYPE_TIMESTAMP = 15;
    public static final byte U_TYPE_SET = 16;
    public static final byte U_TYPE_MULTISET = 17;
    public static final byte U_TYPE_SEQUENCE = 18;
    public static final byte U_TYPE_OBJECT = 19;
    public static final byte U_TYPE_RESULTSET = 20;
    public static final byte U_TYPE_BIGINT = 21;
    public static final byte U_TYPE_DATETIME = 22;
    public static final byte U_TYPE_BLOB = 23;
    public static final byte U_TYPE_CLOB = 24;

    static boolean isCollectionType(byte by) {
        return by == 16 || by == 17 || by == 18;
    }

    static byte getObjArrBaseDBtype(Object object) {
        if (object instanceof String[]) {
            return 2;
        }
        if (object instanceof Byte[]) {
            return 9;
        }
        if (object instanceof byte[][]) {
            return 6;
        }
        if (object instanceof Boolean[]) {
            return 5;
        }
        if (object instanceof Short[]) {
            return 9;
        }
        if (object instanceof Integer[]) {
            return 8;
        }
        if (object instanceof Long[]) {
            return 21;
        }
        if (object instanceof Double[]) {
            return 12;
        }
        if (object instanceof Float[]) {
            return 11;
        }
        if (object instanceof BigDecimal[]) {
            return 7;
        }
        if (object instanceof Date[]) {
            return 13;
        }
        if (object instanceof Time[]) {
            return 14;
        }
        if (object instanceof Timestamp[]) {
            for (int i = 0; i < ((Object[])object).length; ++i) {
                if (CUBRIDTimestamp.isTimestampType((Timestamp)((Object[])object)[i])) continue;
                return 22;
            }
            return 15;
        }
        if (object instanceof CUBRIDOID[]) {
            return 19;
        }
        if (object instanceof CUBRIDBlob[]) {
            return 23;
        }
        if (object instanceof CUBRIDClob[]) {
            return 24;
        }
        return 0;
    }

    static byte getObjectDBtype(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return 2;
        }
        if (object instanceof Byte) {
            return 9;
        }
        if (object instanceof byte[]) {
            return 6;
        }
        if (object instanceof Boolean) {
            return 5;
        }
        if (object instanceof Short) {
            return 9;
        }
        if (object instanceof Integer) {
            return 8;
        }
        if (object instanceof Long) {
            return 21;
        }
        if (object instanceof Double) {
            return 12;
        }
        if (object instanceof Float) {
            return 11;
        }
        if (object instanceof BigDecimal || object instanceof Long) {
            return 7;
        }
        if (object instanceof Date) {
            return 13;
        }
        if (object instanceof Time) {
            return 14;
        }
        if (object instanceof Timestamp) {
            if (CUBRIDTimestamp.isTimestampType((Timestamp)object)) {
                return 15;
            }
            return 22;
        }
        if (object instanceof CUBRIDOID) {
            return 19;
        }
        if (object instanceof CUBRIDBlob) {
            return 23;
        }
        if (object instanceof CUBRIDClob) {
            return 24;
        }
        if (object instanceof Object[]) {
            return 18;
        }
        return 0;
    }
}

