/*
 * Decompiled with CFR 0.152.
 */
package cubrid.jdbc.log;

import cubrid.jdbc.log.Log;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class BasicLogger
implements Log {
    private static final int FATAL = 0;
    private static final int ERROR = 1;
    private static final int WARN = 2;
    private static final int INFO = 3;
    private static final int DEBUG = 4;
    private static final int TRACE = 5;
    private static final int ALL = 6;
    private int logLevel;
    private static Hashtable<String, PrintWriter> writerTable = new Hashtable();
    PrintWriter writer;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public BasicLogger(String string) {
        this.initialize(string, 6);
    }

    public BasicLogger(String string, int n) {
        this.initialize(string, n);
    }

    private void initialize(String string, int n) {
        this.logLevel = n;
        try {
            File file = new File(string);
            String string2 = file.getCanonicalPath();
            this.writer = writerTable.get(string2);
            if (this.writer == null) {
                this.writer = new PrintWriter(string2);
                writerTable.put(string2, this.writer);
            }
        }
        catch (IOException iOException) {
            System.err.println("WARNING - Could not create a file for logging.\n The standard error will be using to log.");
            iOException.printStackTrace();
            this.writer = writerTable.get("stderr");
        }
    }

    public void logDebug(String string) {
        this.logDebug(string, null);
    }

    public void logDebug(String string, Throwable throwable) {
        this.logInternal(4, string, throwable);
    }

    public void logError(String string) {
        this.logError(string, null);
    }

    public void logError(String string, Throwable throwable) {
        this.logInternal(1, string, throwable);
    }

    public void logFatal(String string) {
        this.logFatal(string, null);
    }

    public void logFatal(String string, Throwable throwable) {
        this.logInternal(0, string, throwable);
    }

    public void logInfo(String string) {
        this.logInfo(string, null);
    }

    public void logInfo(String string, Throwable throwable) {
        this.logInternal(3, string, throwable);
    }

    public void logTrace(String string) {
        this.logTrace(string);
    }

    public void logTrace(String string, Throwable throwable) {
        this.logInternal(5, string, throwable);
    }

    public void logWarn(String string) {
        this.logWarn(string);
    }

    public void logWarn(String string, Throwable throwable) {
        this.logInternal(2, string, throwable);
    }

    private synchronized void logInternal(int n, String string, Throwable throwable) {
        if (this.logLevel < n) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.dateFormat.format(new Date())).append('|');
        switch (n) {
            case 0: {
                stringBuffer.append("FATAL");
                break;
            }
            case 1: {
                stringBuffer.append("ERROR");
                break;
            }
            case 2: {
                stringBuffer.append("WARN");
                break;
            }
            case 3: {
                stringBuffer.append("INFO");
                break;
            }
            case 4: {
                stringBuffer.append("DEBUG");
                break;
            }
            case 5: {
                stringBuffer.append("TRACE");
            }
        }
        stringBuffer.append('|').append(string);
        this.writer.println(stringBuffer.toString());
        if (throwable != null) {
            throwable.printStackTrace(this.writer);
        }
        this.writer.flush();
    }

    static {
        writerTable.put("stderr", new PrintWriter(System.err));
    }
}

