/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.bat.core.item.file.transform;

import egovframework.rte.bat.core.reflection.EgovReflectionSupport;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class EgovFieldExtractor<T>
implements FieldExtractor<T>,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EgovFieldExtractor.class);
    private String[] names;
    private EgovReflectionSupport<T> reflection;

    public void setNames(String[] names) {
        Assert.notNull((Object)names, (String)"Names must be non-null");
        this.names = Arrays.asList(names).toArray(new String[names.length]);
    }

    public Object[] extract(T item) {
        ArrayList<Object> values = new ArrayList<Object>();
        try {
            this.reflection.generateGetterMethodMap(this.names, item);
        }
        catch (Exception e) {
            LOGGER.debug("debug", (Throwable)e);
        }
        for (int i = 0; i < this.names.length; ++i) {
            values.add(this.reflection.invokeGettterMethod(item, this.names[i]));
        }
        return values.toArray();
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.names, (String)"The 'names' property must be set.");
        this.reflection = new EgovReflectionSupport();
    }
}

