/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.impl.AbstractDataIdGnrService;
import java.math.BigDecimal;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractDataBlockIdGnrService
extends AbstractDataIdGnrService
implements InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataBlockIdGnrService.class);
    private BigDecimal mFirstBigDecimal;
    private long mFirstLong;
    private int mAllocated;
    protected int blockSize;

    protected abstract BigDecimal allocateBigDecimalIdBlock(int var1) throws FdlException;

    protected abstract long allocateLongIdBlock(int var1) throws FdlException;

    @Override
    protected BigDecimal getNextBigDecimalIdInner() throws FdlException {
        if (this.mAllocated >= this.blockSize) {
            try {
                this.mFirstBigDecimal = this.allocateBigDecimalIdBlock(this.blockSize);
                this.mAllocated = 0;
            }
            catch (FdlException be) {
                this.mAllocated = Integer.MAX_VALUE;
                throw be;
            }
        }
        BigDecimal id = this.mFirstBigDecimal.add(new BigDecimal(this.mAllocated));
        ++this.mAllocated;
        return id;
    }

    @Override
    protected long getNextLongIdInner() throws FdlException {
        long id;
        if (this.mAllocated >= this.blockSize) {
            try {
                this.mFirstLong = this.allocateLongIdBlock(this.blockSize);
                this.mAllocated = 0;
            }
            catch (FdlException e) {
                this.mAllocated = Integer.MAX_VALUE;
                throw e;
            }
        }
        if ((id = this.mFirstLong + (long)this.mAllocated) < 0L) {
            LOGGER.error(this.messageSource.getMessage("error.idgnr.greater.maxid", (Object[])new String[]{"Long"}, Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.idgnr.greater.maxid");
        }
        ++this.mAllocated;
        return id;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void afterPropertiesSet() throws Exception {
        this.mAllocated = Integer.MAX_VALUE;
    }
}

