/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import egovframework.rte.fdl.cmmn.exception.FdlException;
import egovframework.rte.fdl.idgnr.EgovIdGnrService;
import egovframework.rte.fdl.idgnr.EgovIdGnrStrategy;
import java.math.BigDecimal;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;

public abstract class AbstractIdGnrService
implements EgovIdGnrService,
ApplicationContextAware,
BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractIdGnrService.class);
    private BeanFactory beanFactory;
    private static final BigDecimal BIG_DECIMAL_MAX_LONG = new BigDecimal(Long.MAX_VALUE);
    private final Object mSemaphore = new Object();
    private EgovIdGnrStrategy strategy = new EgovIdGnrStrategy(){

        @Override
        public String makeId(String originalId) {
            return originalId;
        }
    };
    protected boolean useBigDecimals = false;
    protected MessageSource messageSource;

    protected abstract BigDecimal getNextBigDecimalIdInner() throws FdlException;

    protected abstract long getNextLongIdInner() throws FdlException;

    public final void setUseBigDecimals(boolean useBigDecimals) {
        this.useBigDecimals = useBigDecimals;
    }

    protected final boolean isUsingBigDecimals() {
        return this.useBigDecimals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getNextLongIdChecked(long maxId) throws FdlException {
        long nextId;
        if (this.useBigDecimals) {
            BigDecimal bd;
            Object object = this.mSemaphore;
            synchronized (object) {
                bd = this.getNextBigDecimalIdInner();
            }
            if (bd.compareTo(BIG_DECIMAL_MAX_LONG) > 0) {
                LOGGER.error(this.messageSource.getMessage("error.idgnr.greater.maxid", (Object[])new String[]{"Long"}, Locale.getDefault()));
                throw new FdlException(this.messageSource, "error.idgnr.greater.maxid");
            }
            nextId = bd.longValue();
        } else {
            Object object = this.mSemaphore;
            synchronized (object) {
                nextId = this.getNextLongIdInner();
            }
        }
        if (nextId > maxId) {
            LOGGER.error(this.messageSource.getMessage("error.idgnr.greater.maxid", (Object[])new String[]{"Long"}, Locale.getDefault()));
            throw new FdlException(this.messageSource, "error.idgnr.greater.maxid");
        }
        return nextId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final BigDecimal getNextBigDecimalId() throws FdlException {
        BigDecimal bd;
        if (this.useBigDecimals) {
            Object object = this.mSemaphore;
            synchronized (object) {
                bd = this.getNextBigDecimalIdInner();
            }
        }
        Object object = this.mSemaphore;
        synchronized (object) {
            bd = new BigDecimal(this.getNextLongIdInner());
        }
        return bd;
    }

    @Override
    public final long getNextLongId() throws FdlException {
        return this.getNextLongIdChecked(Long.MAX_VALUE);
    }

    @Override
    public final int getNextIntegerId() throws FdlException {
        return (int)this.getNextLongIdChecked(Integer.MAX_VALUE);
    }

    @Override
    public final short getNextShortId() throws FdlException {
        return (short)this.getNextLongIdChecked(32767L);
    }

    @Override
    public final byte getNextByteId() throws FdlException {
        return (byte)this.getNextLongIdChecked(127L);
    }

    @Override
    public final String getNextStringId() throws FdlException {
        return this.strategy.makeId(this.getNextBigDecimalId().toString());
    }

    @Override
    public String getNextStringId(EgovIdGnrStrategy strategy) throws FdlException {
        this.strategy = strategy;
        return this.getNextStringId();
    }

    @Override
    public String getNextStringId(String strategyId) throws FdlException {
        this.strategy = (EgovIdGnrStrategy)this.beanFactory.getBean(strategyId);
        return this.getNextStringId();
    }

    public EgovIdGnrStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(EgovIdGnrStrategy strategy) {
        this.strategy = strategy;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.messageSource = (MessageSource)applicationContext.getBean("messageSource");
    }
}

