/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.idgnr.impl;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Random;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TimeBasedUUIDGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeBasedUUIDGenerator.class);
    public static final Object lock = new Object();
    private static long lastTime;
    private static long clockSequence;
    private static final long hostIdentifier;

    TimeBasedUUIDGenerator() {
    }

    public static final UUID generateId() {
        return TimeBasedUUIDGenerator.generateIdFromTimestamp(System.currentTimeMillis(), 0L);
    }

    public static final UUID generateId(long hostId) {
        return TimeBasedUUIDGenerator.generateIdFromTimestamp(System.currentTimeMillis(), hostId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final UUID generateIdFromTimestamp(long currentTimeMillis, long hostId) {
        Object object = lock;
        synchronized (object) {
            if (currentTimeMillis > lastTime) {
                lastTime = currentTimeMillis;
                clockSequence = 0L;
            } else {
                ++clockSequence;
            }
        }
        long time = currentTimeMillis;
        time = currentTimeMillis << 32;
        time |= (currentTimeMillis & 0xFFFF00000000L) >> 16;
        long clockSequenceHi = clockSequence;
        long lsb = hostId != 0L ? clockSequenceHi | hostId : (clockSequenceHi <<= 48) | hostIdentifier;
        return new UUID(time |= 0x1000L | currentTimeMillis >> 48 & 0xFFFL, lsb);
    }

    private static final long getHostId() {
        long macAddressAsLong = 0L;
        try {
            Random random = new Random();
            InetAddress address = InetAddress.getLocalHost();
            NetworkInterface ni = NetworkInterface.getByInetAddress(address);
            if (ni != null) {
                byte[] mac = ni.getHardwareAddress();
                random.nextBytes(mac);
                if (mac != null) {
                    for (int i = 0; i < mac.length; ++i) {
                        macAddressAsLong <<= 8;
                        macAddressAsLong ^= (long)mac[i] & 0xFFL;
                    }
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("getHostId Exception", (Throwable)ex);
        }
        LOGGER.debug("MAC Address (from Network Interface) : " + TimeBasedUUIDGenerator.getMacAddressAsString(TimeBasedUUIDGenerator.getMacAddress(macAddressAsLong)));
        return macAddressAsLong;
    }

    public static byte[] getMacAddress(long address) {
        byte[] addressInBytes = new byte[]{(byte)(address >> 40 & 0xFFL), (byte)(address >> 32 & 0xFFL), (byte)(address >> 24 & 0xFFL), (byte)(address >> 16 & 0xFFL), (byte)(address >> 8 & 0xFFL), (byte)(address >> 0 & 0xFFL)};
        return addressInBytes;
    }

    public static String getMacAddressAsString(byte[] address) {
        StringBuilder builder = new StringBuilder();
        for (byte b : address) {
            if (builder.length() > 0) {
                builder.append(":");
            }
            builder.append(String.format("%02X", b & 0xFF));
        }
        return builder.toString();
    }

    public static long getMacAddressAsLong(byte[] address) {
        long mac = 0L;
        for (int i = 0; i < 6; ++i) {
            long t = ((long)address[i] & 0xFFL) << (5 - i) * 8;
            mac |= t;
        }
        return mac;
    }

    static {
        clockSequence = 0L;
        hostIdentifier = TimeBasedUUIDGenerator.getHostId();
    }
}

