/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.fdl.security.securedobject.impl;

import egovframework.rte.fdl.security.config.SecurityConfig;
import egovframework.rte.fdl.security.securedobject.EgovSecuredObjectService;
import egovframework.rte.fdl.security.securedobject.impl.SecuredObjectDAO;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class SecuredObjectServiceImpl
implements EgovSecuredObjectService,
ApplicationContextAware {
    private SecuredObjectDAO securedObjectDAO;
    private String requestMatcherType = "ant";

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        SecurityConfig config;
        if (context.getBeanNamesForType(SecurityConfig.class).length > 0 && (config = (SecurityConfig)context.getBean(SecurityConfig.class)) != null) {
            this.requestMatcherType = config.getRequestMatcherType();
        }
    }

    public void setSecuredObjectDAO(SecuredObjectDAO securedObjectDAO) {
        this.securedObjectDAO = securedObjectDAO;
    }

    public void setRequestMatcherType(String requestMatcherType) {
        this.requestMatcherType = requestMatcherType;
    }

    @Override
    public LinkedHashMap<RequestMatcher, List<ConfigAttribute>> getRolesAndUrl() throws Exception {
        LinkedHashMap<RequestMatcher, List<ConfigAttribute>> ret = new LinkedHashMap<RequestMatcher, List<ConfigAttribute>>();
        LinkedHashMap<Object, List<ConfigAttribute>> data = this.securedObjectDAO.getRolesAndUrl(this.requestMatcherType);
        Set<Object> keys = data.keySet();
        for (Object key : keys) {
            ret.put((RequestMatcher)key, data.get(key));
        }
        return ret;
    }

    @Override
    public LinkedHashMap<String, List<ConfigAttribute>> getRolesAndMethod() throws Exception {
        LinkedHashMap<String, List<ConfigAttribute>> ret = new LinkedHashMap<String, List<ConfigAttribute>>();
        LinkedHashMap<Object, List<ConfigAttribute>> data = this.securedObjectDAO.getRolesAndMethod();
        Set<Object> keys = data.keySet();
        for (Object key : keys) {
            ret.put((String)key, data.get(key));
        }
        return ret;
    }

    @Override
    public LinkedHashMap<String, List<ConfigAttribute>> getRolesAndPointcut() throws Exception {
        LinkedHashMap<String, List<ConfigAttribute>> ret = new LinkedHashMap<String, List<ConfigAttribute>>();
        LinkedHashMap<Object, List<ConfigAttribute>> data = this.securedObjectDAO.getRolesAndPointcut();
        Set<Object> keys = data.keySet();
        for (Object key : keys) {
            ret.put((String)key, data.get(key));
        }
        return ret;
    }

    @Override
    public List<ConfigAttribute> getMatchedRequestMapping(String url) throws Exception {
        return this.securedObjectDAO.getRegexMatchedRequestMapping(url);
    }

    @Override
    public String getHierarchicalRoles() throws Exception {
        return this.securedObjectDAO.getHierarchicalRoles();
    }
}

