/*
 * Decompiled with CFR 0.152.
 */
package egovframework.rte.ptl.mvc.tags.ui.pagination;

import egovframework.rte.ptl.mvc.tags.ui.pagination.PaginationInfo;
import egovframework.rte.ptl.mvc.tags.ui.pagination.PaginationRenderer;
import java.text.MessageFormat;

public abstract class AbstractPaginationRenderer
implements PaginationRenderer {
    public String firstPageLabel;
    public String previousPageLabel;
    public String currentPageLabel;
    public String otherPageLabel;
    public String nextPageLabel;
    public String lastPageLabel;

    @Override
    public String renderPagination(PaginationInfo paginationInfo, String jsFunction) {
        StringBuffer strBuff = new StringBuffer();
        int firstPageNo = paginationInfo.getFirstPageNo();
        int firstPageNoOnPageList = paginationInfo.getFirstPageNoOnPageList();
        int totalPageCount = paginationInfo.getTotalPageCount();
        int pageSize = paginationInfo.getPageSize();
        int lastPageNoOnPageList = paginationInfo.getLastPageNoOnPageList();
        int currentPageNo = paginationInfo.getCurrentPageNo();
        int lastPageNo = paginationInfo.getLastPageNo();
        if (totalPageCount > pageSize) {
            if (firstPageNoOnPageList > pageSize) {
                strBuff.append(MessageFormat.format(this.firstPageLabel, jsFunction, Integer.toString(firstPageNo)));
                strBuff.append(MessageFormat.format(this.previousPageLabel, jsFunction, Integer.toString(firstPageNoOnPageList - 1)));
            } else {
                strBuff.append(MessageFormat.format(this.firstPageLabel, jsFunction, Integer.toString(firstPageNo)));
                strBuff.append(MessageFormat.format(this.previousPageLabel, jsFunction, Integer.toString(firstPageNo)));
            }
        }
        for (int i = firstPageNoOnPageList; i <= lastPageNoOnPageList; ++i) {
            if (i == currentPageNo) {
                strBuff.append(MessageFormat.format(this.currentPageLabel, Integer.toString(i)));
                continue;
            }
            strBuff.append(MessageFormat.format(this.otherPageLabel, jsFunction, Integer.toString(i), Integer.toString(i)));
        }
        if (totalPageCount > pageSize) {
            if (lastPageNoOnPageList < totalPageCount) {
                strBuff.append(MessageFormat.format(this.nextPageLabel, jsFunction, Integer.toString(firstPageNoOnPageList + pageSize)));
                strBuff.append(MessageFormat.format(this.lastPageLabel, jsFunction, Integer.toString(lastPageNo)));
            } else {
                strBuff.append(MessageFormat.format(this.nextPageLabel, jsFunction, Integer.toString(lastPageNo)));
                strBuff.append(MessageFormat.format(this.lastPageLabel, jsFunction, Integer.toString(lastPageNo)));
            }
        }
        return strBuff.toString();
    }
}

