/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.db.pool;

import java.util.Properties;

public class JdbcConnSpec {
    private String driver = null;
    private String url = null;
    private String user = null;
    private String password = null;
    private Properties properties;

    public JdbcConnSpec(String driver, String url, String user, String password) {
        this.driver = driver == null ? "" : driver;
        this.url = url == null ? "" : url;
        this.user = user == null ? "" : user;
        this.password = password == null ? "" : password;
        this.properties = new Properties();
        this.properties.put("driver", driver);
        this.properties.put("url", url);
        this.properties.put("user", user);
        this.properties.put("password", password);
    }

    public JdbcConnSpec(Properties props) {
        this.driver = (String)props.get("driver");
        this.url = (String)props.get("url");
        this.user = (String)props.get("user");
        this.password = (String)props.get("password");
        this.properties = props;
    }

    public boolean equals(JdbcConnSpec spec) {
        if (spec == null) {
            return false;
        }
        if (!spec.getDriver().equals(this.driver)) {
            return false;
        }
        if (!spec.getURL().equals(this.url)) {
            return false;
        }
        if (!spec.getUser().equals(this.user)) {
            return false;
        }
        return spec.getPassword().equals(this.password);
    }

    public String getDriver() {
        return this.driver;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }
}

