/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.jdf;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DateTime {
    private DateTime() {
    }

    public static Date check(String s) throws ParseException {
        return DateTime.check(s, "yyyyMMdd");
    }

    public static Date check(String s, String format) throws ParseException {
        if (s == null) {
            throw new ParseException("date string to check is null", 0);
        }
        if (format == null) {
            throw new ParseException("format string to check date is null", 0);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(s);
        }
        catch (ParseException e) {
            throw new ParseException(" wrong date:\"" + s + "\" with format \"" + format + "\"", 0);
        }
        if (!formatter.format(date).equals(s)) {
            throw new ParseException("Out of bound date:\"" + s + "\" with format \"" + format + "\"", 0);
        }
        return date;
    }

    public static boolean isValid(String s) throws Exception {
        return DateTime.isValid(s, "yyyyMMdd");
    }

    public static boolean isValid(String s, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = null;
        try {
            date = formatter.parse(s);
        }
        catch (ParseException e) {
            return false;
        }
        return formatter.format(date).equals(s);
    }

    public static String getDateString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static int getDay() {
        return DateTime.getNumberByPattern("dd");
    }

    public static int getYear() {
        return DateTime.getNumberByPattern("yyyy");
    }

    public static int getMonth() {
        return DateTime.getNumberByPattern("MM");
    }

    public static int getNumberByPattern(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(new Date());
        return Integer.parseInt(dateString);
    }

    public static String getFormatString(String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern, Locale.KOREA);
        String dateString = formatter.format(new Date());
        return dateString;
    }

    public static String getShortDateString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static String getShortTimeString() {
        SimpleDateFormat formatter = new SimpleDateFormat("HHmmss", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static String getTimeStampString() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd-HH:mm:ss:SSS", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static String getTimeString() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss", Locale.KOREA);
        return formatter.format(new Date());
    }

    public static int whichDay(String s) throws ParseException {
        return DateTime.whichDay(s, "yyyyMMdd");
    }

    public static int whichDay(String s, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateTime.check(s, format);
        Calendar calendar = formatter.getCalendar();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int daysBetween(String from, String to) throws ParseException {
        return DateTime.daysBetween(from, to, "yyyyMMdd");
    }

    public static int daysBetween(String from, String to, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date d1 = DateTime.check(from, format);
        Date d2 = DateTime.check(to, format);
        long duration = d2.getTime() - d1.getTime();
        return (int)(duration / 86400000L);
    }

    public static int ageBetween(String from, String to) throws ParseException {
        return DateTime.ageBetween(from, to, "yyyyMMdd");
    }

    public static int ageBetween(String from, String to, String format) throws ParseException {
        return DateTime.daysBetween(from, to, format) / 365;
    }

    public static String addDays(String s, int day) throws ParseException {
        return DateTime.addDays(s, day, "yyyyMMdd");
    }

    public static String addDays(String s, int day, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateTime.check(s, format);
        date.setTime(date.getTime() + (long)day * 1000L * 60L * 60L * 24L);
        return formatter.format(date);
    }

    public static String addMonths(String s, int month) throws Exception {
        return DateTime.addMonths(s, month, "yyyyMMdd");
    }

    /*
     * Unable to fully structure code
     */
    public static String addMonths(String s, int addMonth, String format) throws Exception {
        block4: {
            formatter = new SimpleDateFormat(format, Locale.KOREA);
            date = DateTime.check(s, format);
            yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
            monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
            dayFormat = new SimpleDateFormat("dd", Locale.KOREA);
            year = Integer.parseInt(yearFormat.format(date));
            month = Integer.parseInt(monthFormat.format(date));
            day = Integer.parseInt(dayFormat.format(date));
            month += addMonth;
            if (addMonth <= 0) ** GOTO lbl18
            while (month > 12) {
                month -= 12;
                ++year;
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                month += 12;
                --year;
lbl18:
                // 2 sources

                ** while (month <= 0)
            }
        }
        fourDf = new DecimalFormat("0000");
        twoDf = new DecimalFormat("00");
        tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
        targetDate = null;
        try {
            targetDate = DateTime.check(tempDate, "yyyyMMdd");
        }
        catch (ParseException pe) {
            day = DateTime.lastDay(year, month);
            tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
            targetDate = DateTime.check(tempDate, "yyyyMMdd");
        }
        return formatter.format(targetDate);
    }

    public static String addYears(String s, int year) throws ParseException {
        return DateTime.addYears(s, year, "yyyyMMdd");
    }

    public static String addYears(String s, int year, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateTime.check(s, format);
        date.setTime(date.getTime() + (long)year * 1000L * 60L * 60L * 24L * 366L);
        return formatter.format(date);
    }

    public static int monthsBetween(String from, String to) throws ParseException {
        return DateTime.monthsBetween(from, to, "yyyyMMdd");
    }

    public static int monthsBetween(String from, String to, String format) throws ParseException {
        Date toDate;
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date fromDate = DateTime.check(from, format);
        if (fromDate.compareTo(toDate = DateTime.check(to, format)) == 0) {
            return 0;
        }
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
        SimpleDateFormat dayFormat = new SimpleDateFormat("dd", Locale.KOREA);
        int fromYear = Integer.parseInt(yearFormat.format(fromDate));
        int toYear = Integer.parseInt(yearFormat.format(toDate));
        int fromMonth = Integer.parseInt(monthFormat.format(fromDate));
        int toMonth = Integer.parseInt(monthFormat.format(toDate));
        int fromDay = Integer.parseInt(dayFormat.format(fromDate));
        int toDay = Integer.parseInt(dayFormat.format(toDate));
        int result = 0;
        result += (toYear - fromYear) * 12;
        result += toMonth - fromMonth;
        if (toDay - fromDay > 0) {
            result += toDate.compareTo(fromDate);
        }
        return result;
    }

    public static String lastDayOfMonth(String src) throws ParseException {
        return DateTime.lastDayOfMonth(src, "yyyyMMdd");
    }

    public static String lastDayOfMonth(String src, String format) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.KOREA);
        Date date = DateTime.check(src, format);
        SimpleDateFormat yearFormat = new SimpleDateFormat("yyyy", Locale.KOREA);
        SimpleDateFormat monthFormat = new SimpleDateFormat("MM", Locale.KOREA);
        int year = Integer.parseInt(yearFormat.format(date));
        int month = Integer.parseInt(monthFormat.format(date));
        int day = DateTime.lastDay(year, month);
        DecimalFormat fourDf = new DecimalFormat("0000");
        DecimalFormat twoDf = new DecimalFormat("00");
        String tempDate = String.valueOf(String.valueOf(fourDf.format(year))) + String.valueOf(twoDf.format(month)) + String.valueOf(twoDf.format(day));
        date = DateTime.check(tempDate, format);
        return formatter.format(date);
    }

    private static int lastDay(int year, int month) throws ParseException {
        int day = 0;
        switch (month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                day = 31;
                break;
            }
            case 2: {
                if (year % 4 == 0) {
                    if (year % 100 == 0 && year % 400 != 0) {
                        day = 28;
                        break;
                    }
                    day = 29;
                    break;
                }
                day = 28;
                break;
            }
            default: {
                day = 30;
            }
        }
        return day;
    }
}

