/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.server;

import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.MessageStore;
import com.dsjdf.jdf.Utility;
import com.dsjdf.server.DSServerWorker;
import com.dsjdf.server.DefaultEventHandler;
import com.dsjdf.server.EventHandler;
import com.dsjdf.server.IPCheckerFileNotFoundException;
import com.dsjdf.server.IncorrectPortException;
import com.dsjdf.server.ipchecker.IPChecker;
import com.dsjdf.threadpool.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.ServerSocket;
import java.util.LinkedList;

public abstract class DSSocketServer
extends Thread {
    private final String serverName;
    private ServerSocket main;
    private int port;
    private int minThreads;
    private int maxThreads;
    private boolean isSoLinger;
    private int soLinger;
    private boolean isSoKeepAlive;
    private int soTimeOut;
    private boolean isDaemon;
    private ThreadPool threads;
    private String prototypeWorkerClassName;
    private DSServerWorker prototypeWorker;
    private LinkedList workerHandlers = new LinkedList();
    private EventHandler eventHandler;
    private boolean isConf;
    private int serverType;
    private boolean isRun;
    private boolean isShutdownByControlServer;
    private Object thisObject;

    public DSSocketServer(String serverName, int serverType) {
        this.serverName = serverName;
        this.serverType = serverType;
        this.isShutdownByControlServer = false;
        try {
            Configuration conf = new Configuration();
            this.port = conf.getInt(String.valueOf(serverName) + ".serversocket.port");
            if (this.port <= 0 || this.port > 65535) {
                throw new IncorrectPortException();
            }
            this.minThreads = conf.getInt(String.valueOf(serverName) + ".minclient");
            this.maxThreads = conf.getInt(String.valueOf(serverName) + ".maxclient");
            this.soLinger = conf.getInt(String.valueOf(serverName) + ".serversocket.SO_LINGER_TIME");
            this.isSoLinger = this.soLinger != 0;
            this.soLinger /= 1000;
            this.isSoKeepAlive = conf.getBoolean(String.valueOf(serverName) + ".serversocket.SO_KEEPALIVE");
            this.soTimeOut = conf.getInt(String.valueOf(serverName) + ".serversocket.SO_TIMEOUT_TIME");
            this.isDaemon = conf.getBoolean(String.valueOf(serverName) + ".is_daemon_thread");
            this.prototypeWorkerClassName = conf.get(String.valueOf(serverName) + ".serversocket.worker.class").trim();
            String allowFilePath = conf.get(String.valueOf(serverName) + ".ipfilter.allowIPFile");
            String denyFilePath = conf.get(String.valueOf(serverName) + ".ipfilter.denyIPFile");
            File file = new File(allowFilePath);
            if (!file.exists()) {
                throw new IPCheckerFileNotFoundException();
            }
            file = null;
            file = new File(denyFilePath);
            if (!file.exists()) {
                throw new IPCheckerFileNotFoundException();
            }
            file = null;
            this.isConf = true;
            this.isRun = true;
            this.initialize();
        }
        catch (ConfigurationException e) {
            this.isConf = false;
            Logger.sys.println(this, Utility.getStackTrace(e));
        }
        catch (IncorrectPortException e) {
            this.isConf = false;
            this.setIsShutdownByControlServer(true);
            MessageStore msg = new MessageStore("SYS017");
            msg.setArg("servername", serverName);
            Logger.sys.println(this, msg);
        }
        catch (IPCheckerFileNotFoundException e) {
            this.isConf = false;
            this.setIsShutdownByControlServer(true);
            MessageStore msg = new MessageStore("SYS018");
            msg.setArg("servername", serverName);
            Logger.sys.println(this, msg);
        }
    }

    public abstract void initialize();

    public abstract void terminate();

    public void setThisObject(Object thisObject) {
        this.thisObject = thisObject;
    }

    private DSServerWorker createWorkerFromPrototype() {
        DSServerWorker replica = this.prototypeWorker.replicate();
        replica.workerHandlers = this.workerHandlers;
        return replica;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.isConf) {
            MessageStore msg;
            MessageStore msg22;
            this.threads = new ThreadPool(this.minThreads, this.maxThreads, this.serverName);
            this.eventHandler = new DefaultEventHandler(this.serverName);
            if (this.prototypeWorkerClassName == null) {
                MessageStore msg3 = new MessageStore("SYS007");
                msg3.setArg("servername", this.serverName);
                this.eventHandler.onError(msg3);
                return;
            }
            try {
                Class<?> prototypeWorkerClass = Class.forName(this.prototypeWorkerClassName);
                Class[] argsTypes = new Class[]{};
                Constructor<?> cons = prototypeWorkerClass.getConstructor(argsTypes);
                Object[] args = new Object[]{};
                this.prototypeWorker = (DSServerWorker)cons.newInstance(args);
                msg22 = new MessageStore("MSG006");
                msg22.setArg("servername", this.serverName);
                msg22.setArg("driverName", this.prototypeWorkerClassName);
                Logger.info.println(this, msg22);
            }
            catch (Exception e) {
                Logger.sys.println(this, Utility.getStackTrace(e));
            }
            if (this.prototypeWorker == null) {
                msg = new MessageStore("SYS008");
                msg.setArg("servername", this.serverName);
                this.eventHandler.onError(msg);
                return;
            }
            try {
                this.main = new ServerSocket(this.port);
                msg = new MessageStore("MSG007");
                msg.setArg("servername", this.serverName);
                Logger.info.println(this, msg);
            }
            catch (IOException e1) {
                MessageStore msg4 = new MessageStore("SYS006");
                msg4.setArg("servername", this.serverName);
                this.eventHandler.onError(msg4, (Exception)e1);
                return;
            }
            int i = 0;
            while (i < this.minThreads) {
                this.workerHandlers.addLast(this.createWorkerFromPrototype());
                ++i;
            }
            if (this.isDaemon) {
                this.setDaemon(true);
                MessageStore msg5 = new MessageStore("MSG008");
                msg5.setArg("servername", this.serverName);
                Logger.info.println(this, msg5);
            }
            this.eventHandler.onStart();
            IPChecker ipChecker = new IPChecker(this.serverName);
            boolean isCorrectPriority = ipChecker.getIsCorrectPriority();
            if (!isCorrectPriority) {
                this.isRun = false;
                MessageStore msg6 = new MessageStore("SYS015");
                msg6.setArg("servername", this.serverName);
                Logger.sys.println(this, msg6);
                this.setIsShutdownByControlServer(true);
            }
            DSServerWorker worker = null;
            while (this.isRun) {
                try {
                    LinkedList args = this.workerHandlers;
                    synchronized (args) {
                        worker = this.workerHandlers.size() > 0 ? (DSServerWorker)this.workerHandlers.removeLast() : this.createWorkerFromPrototype();
                    }
                    worker.socket = this.main.accept();
                    worker.serverName = this.serverName;
                    int ipCheckRet = ipChecker.isDenyIP(worker.socket.getInetAddress().getHostAddress());
                    if (ipCheckRet == 1) {
                        try {
                            Logger.warn.println(this, "This ip is denied");
                            worker.socket.close();
                        }
                        catch (Exception msg22) {}
                        continue;
                    }
                    if (ipCheckRet == 2) {
                        msg22 = new MessageStore("SYS015");
                        msg22.setArg("servername", this.serverName);
                        Logger.sys.println(this, msg22);
                        this.setIsShutdownByControlServer(true);
                        this.isRun = false;
                        DSSocketServer.interrupted();
                    }
                    if (this.isInterrupted() || !this.isRun) {
                        try {
                            worker.socket.close();
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    worker.socket.setSoLinger(this.isSoLinger, this.soLinger);
                    worker.socket.setKeepAlive(this.isSoKeepAlive);
                    worker.socket.setSoTimeout(this.soTimeOut);
                    this.threads.execute(worker);
                }
                catch (Exception e) {
                    try {
                        worker.socket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            try {
                this.main.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.threads.close();
            MessageStore msg7 = new MessageStore("MSG003");
            msg7.setArg("servername", this.serverName);
            Logger.info.println(this, msg7);
        } else {
            MessageStore msg = new MessageStore("SYS005");
            msg.setArg("servername", this.serverName);
            if (this.eventHandler != null) {
                this.eventHandler.onError(msg);
            }
        }
        this.terminate();
        this.isRun = false;
    }

    public void kill() {
        try {
            this.main.close();
            this.threads.close();
            this.terminate();
            this.isRun = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isRun() {
        return this.isRun;
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getPort() {
        return this.port;
    }

    public String getThreadPoolData(String carriageReturn) {
        return this.threads.toStringServer(carriageReturn);
    }

    public void setIsShutdownByControlServer(boolean isShutdownByWatchDog) {
        this.isShutdownByControlServer = isShutdownByWatchDog;
    }

    public boolean getIsShutdownByControlServer() {
        return this.isShutdownByControlServer;
    }

    public Object getVar(String varname) {
        try {
            Configuration conf = new Configuration();
            String className = conf.get(String.valueOf(this.serverName) + ".serversocket.class");
            Class<?> cc = Class.forName(className);
            Field field = cc.getField(varname);
            return field.get(this.thisObject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setVar(String varname, Object value) {
        try {
            Configuration conf = new Configuration();
            String className = conf.get(String.valueOf(this.serverName) + ".serversocket.class");
            Class<?> cc = Class.forName(className);
            Field field = cc.getField(varname);
            field.set(this.thisObject, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

