/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.threadpool;

import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class BlockingQueue {
    private LinkedList elements = new LinkedList();
    private boolean closed = false;
    private boolean rejectEnqueueRequests = false;
    private int waitingThreads = 0;
    private int maximumSize = Integer.MAX_VALUE;

    public BlockingQueue() {
    }

    BlockingQueue(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public final synchronized void enqueue(Object newElement) throws Closed, Full {
        if (this.closed || this.rejectEnqueueRequests) {
            throw new Closed();
        }
        if (this.elements.size() >= this.maximumSize) {
            throw new Full();
        }
        this.elements.addLast(newElement);
        this.notify();
    }

    public final synchronized void enqueue(final Object newElement, final long timeout, final Runnable onRemoval) {
        this.enqueue(newElement);
        new Thread(){
            {
                this.setDaemon(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    boolean found;
                    1.sleep(timeout);
                    BlockingQueue blockingQueue = BlockingQueue.this;
                    synchronized (blockingQueue) {
                        found = BlockingQueue.this.elements.remove(newElement);
                        if (found && BlockingQueue.this.elements.size() == 0 && BlockingQueue.this.rejectEnqueueRequests) {
                            BlockingQueue.this.close();
                        }
                    }
                    if (found && onRemoval != null) {
                        onRemoval.run();
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }.start();
    }

    public final synchronized void enqueue(Object newElement, long timeout) {
        this.enqueue(newElement, timeout, null);
    }

    public final synchronized void enqueueFinalItem(Object last) throws Closed {
        this.enqueue(last);
        this.rejectEnqueueRequests = true;
    }

    public final synchronized Object dequeue(long timeout) throws InterruptedException, Closed, TimedOut {
        if (this.closed) {
            throw new Closed();
        }
        try {
            long expiration;
            long l = expiration = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + timeout;
            if (this.elements.size() <= 0) {
                ++this.waitingThreads;
                while (this.elements.size() <= 0) {
                    this.wait(timeout);
                    if (System.currentTimeMillis() > expiration) {
                        --this.waitingThreads;
                        throw new TimedOut("Timed out waiting to dequeue from BlockingQueue");
                    }
                    if (!this.closed) continue;
                    --this.waitingThreads;
                    throw new Closed();
                }
                --this.waitingThreads;
            }
            Object head = this.elements.removeFirst();
            if (this.elements.size() == 0 && this.rejectEnqueueRequests) {
                this.close();
            }
            return head;
        }
        catch (NoSuchElementException e) {
            throw new Error("Internal error");
        }
    }

    public final synchronized Object dequeue() throws InterruptedException, Closed, TimedOut {
        return this.dequeue(Long.MAX_VALUE);
    }

    public final boolean isEmpty() {
        return this.elements.size() <= 0;
    }

    public final boolean isFull() {
        boolean ret = false;
        if (this.elements.size() >= this.maximumSize) {
            ret = true;
        }
        return ret;
    }

    public final int getWaitingThreadsNum() {
        return this.waitingThreads;
    }

    public synchronized void close() {
        this.closed = true;
        this.elements = null;
        this.notifyAll();
    }

    public synchronized String toString() {
        StringBuffer message = new StringBuffer();
        message.append("\nclosed=" + this.closed);
        message.append("\nrejectEnqueue_requests=" + this.rejectEnqueueRequests);
        message.append("\nwaitingThreads=" + this.waitingThreads);
        message.append("\nmaximumSize=" + this.maximumSize);
        message.append("\n" + this.elements.size() + " elements: " + this.elements);
        message.append("\n");
        return message.toString();
    }

    public synchronized String toString(String carriageReturn) {
        StringBuffer message = new StringBuffer();
        message.append(carriageReturn).append("closed=" + this.closed);
        message.append(carriageReturn).append("rejectEnqueue_requests=" + this.rejectEnqueueRequests);
        message.append(carriageReturn).append("waitingThreads=" + this.waitingThreads);
        message.append(carriageReturn).append("maximumSize=" + this.maximumSize);
        message.append(carriageReturn).append(String.valueOf(this.elements.size()) + " elements: " + this.elements);
        message.append(carriageReturn);
        return message.toString();
    }

    public class Exception
    extends RuntimeException {
        public Exception(String s) {
            super(s);
        }
    }

    public class Closed
    extends Exception {
        private Closed() {
            super("Tried to access closed BlockingQueue.");
        }
    }

    public class TimedOut
    extends Exception {
        private TimedOut() {
            super("Timed out.");
        }

        public TimedOut(String s) {
            super(s);
        }
    }

    public class Full
    extends Exception {
        private Full() {
            super("Attempt to enqueue item to full BlockingQueue.");
        }
    }
}

