/*
 * Decompiled with CFR 0.152.
 */
package com.dsjdf.threadpool;

import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.MessageStore;
import com.dsjdf.threadpool.BlockingQueue;

public final class ThreadPool
extends ThreadGroup {
    private String serverName;
    private final BlockingQueue pool = new BlockingQueue();
    private final int initialSize;
    private final int maximumSize;
    private int idleThreads = 0;
    private int newThreads = 0;
    private int poolSize = 0;
    private volatile boolean hasClosed = false;
    private boolean deflate = false;
    private Object creationLock = new Object();
    private Object pooledThreadsAllRunning;
    private static int groupNumber = 0;
    private static int threadId = 0;

    private boolean allThreadsAreIdle() {
        return this.idleThreads == this.poolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool(int initialThreadCount, int maximumThreadCount) {
        super("ThreadPool" + groupNumber++);
        Object object = this.pooledThreadsAllRunning = new Object();
        synchronized (object) {
            Object object2 = this.creationLock;
            synchronized (object2) {
                this.initialSize = initialThreadCount;
                int n = this.maximumSize = maximumThreadCount > 0 ? maximumThreadCount : Integer.MAX_VALUE;
                if (initialThreadCount > this.maximumSize) {
                    initialThreadCount = this.maximumSize;
                }
                this.newThreads = initialThreadCount;
                int i = initialThreadCount;
                while (--i >= 0) {
                    new PooledThread(this).start();
                }
            }
            if (this.newThreads > 0) {
                try {
                    this.pooledThreadsAllRunning.wait();
                }
                catch (InterruptedException e) {
                    throw new Error("Internal error : unexpected InterruptedException");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadPool(int initialThreadCount, int maximumThreadCount, String serverName) {
        super("ThreadPool" + groupNumber++);
        this.pooledThreadsAllRunning = new Object();
        this.serverName = serverName;
        Object object = this.pooledThreadsAllRunning;
        synchronized (object) {
            Object object2 = this.creationLock;
            synchronized (object2) {
                this.initialSize = initialThreadCount;
                int n = this.maximumSize = maximumThreadCount > 0 ? maximumThreadCount : Integer.MAX_VALUE;
                if (initialThreadCount > this.maximumSize) {
                    initialThreadCount = this.maximumSize;
                }
                this.newThreads = initialThreadCount;
                int i = initialThreadCount;
                while (--i >= 0) {
                    new PooledThread(this).start();
                }
            }
            if (this.newThreads > 0) {
                try {
                    this.pooledThreadsAllRunning.wait();
                }
                catch (InterruptedException e) {
                    throw new Error("Internal error : unexpected InterruptedException");
                }
            }
        }
    }

    public ThreadPool() {
        super("ThreadPool" + groupNumber++);
        this.pooledThreadsAllRunning = new Object();
        this.initialSize = 0;
        this.maximumSize = Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void execute(Runnable action) throws Closed {
        if (this.pool.isFull()) {
            MessageStore msg = new MessageStore("WAR002");
            msg.setArg("servername", this.serverName);
            Logger.warn.println(this, msg);
            return;
        }
        boolean addedThread = false;
        Object object = this.pooledThreadsAllRunning;
        synchronized (object) {
            Object object2 = this.creationLock;
            synchronized (object2) {
                if (this.hasClosed) {
                    throw new Closed();
                }
                this.pool.enqueue(action);
                if (this.poolSize < this.maximumSize && this.pool.getWaitingThreadsNum() == 0) {
                    addedThread = true;
                    this.newThreads = 1;
                    new PooledThread(this).start();
                }
            }
            if (addedThread) {
                try {
                    this.pooledThreadsAllRunning.wait();
                }
                catch (InterruptedException e) {
                    throw new Error("Internal error: unexpected InterruptedException");
                }
            }
        }
    }

    public synchronized void close() {
        this.hasClosed = true;
        this.pool.close();
    }

    public synchronized void join() throws InterruptedException {
        if (!this.allThreadsAreIdle() || !this.pool.isEmpty()) {
            this.wait();
        }
    }

    public synchronized void deflate(boolean doDeflate) {
        this.deflate = doDeflate;
        if (this.deflate) {
            int excessThreads = this.poolSize - this.initialSize;
            while (--excessThreads >= 0) {
                this.pool.enqueue(null);
            }
        }
    }

    public synchronized String toString() {
        StringBuffer message = new StringBuffer();
        message.append("pool:");
        message.append(this.pool.toString());
        message.append("\r\ninitialSize=" + this.initialSize);
        message.append("\r\nmaximumSize=" + this.maximumSize);
        message.append("\r\nidleThreads=" + this.idleThreads);
        message.append("\r\nnewThreads=" + this.newThreads);
        message.append("\r\npoolSize=" + this.poolSize);
        message.append("\r\nhasClosed=" + this.hasClosed);
        message.append("\r\ndeflate=" + this.deflate);
        message.append("\r\n");
        return message.toString();
    }

    public synchronized String toString(String carriageReturn) {
        StringBuffer message = new StringBuffer();
        message.append("pool:");
        message.append(carriageReturn).append(this.pool.toString(carriageReturn));
        message.append(carriageReturn).append("initialSize=" + this.initialSize);
        message.append(carriageReturn).append("maximumSize=" + this.maximumSize);
        message.append(carriageReturn).append("idleThreads=" + this.idleThreads);
        message.append(carriageReturn).append("newThreads=" + this.newThreads);
        message.append(carriageReturn).append("poolSize=" + this.poolSize);
        message.append(carriageReturn).append("hasClosed=" + this.hasClosed);
        message.append(carriageReturn).append("deflate=" + this.deflate);
        message.append(carriageReturn);
        return message.toString();
    }

    public synchronized String toStringServer(String carriageReturn) {
        StringBuffer message = new StringBuffer();
        message.append(carriageReturn).append("init clients number    =" + this.initialSize);
        message.append(carriageReturn).append("max clients number     =" + this.maximumSize);
        message.append(carriageReturn).append("current clients number =" + (this.poolSize - this.idleThreads));
        message.append(carriageReturn);
        return message.toString();
    }

    static /* synthetic */ Object access$2(ThreadPool threadPool) {
        return threadPool.creationLock;
    }

    static /* synthetic */ int access$3(ThreadPool threadPool) {
        return threadPool.idleThreads;
    }

    static /* synthetic */ void access$4(ThreadPool threadPool, int n) {
        threadPool.idleThreads = n;
    }

    static /* synthetic */ int access$5(ThreadPool threadPool) {
        return threadPool.poolSize;
    }

    static /* synthetic */ void access$6(ThreadPool threadPool, int n) {
        threadPool.poolSize = n;
    }

    static /* synthetic */ int access$7(ThreadPool threadPool) {
        return threadPool.newThreads;
    }

    static /* synthetic */ void access$8(ThreadPool threadPool, int n) {
        threadPool.newThreads = n;
    }

    static /* synthetic */ Object access$9(ThreadPool threadPool) {
        return threadPool.pooledThreadsAllRunning;
    }

    static /* synthetic */ boolean access$10(ThreadPool threadPool) {
        return threadPool.hasClosed;
    }

    static /* synthetic */ boolean access$11(ThreadPool threadPool) {
        return threadPool.allThreadsAreIdle();
    }

    static /* synthetic */ BlockingQueue access$12(ThreadPool threadPool) {
        return threadPool.pool;
    }

    private final class PooledThread
    extends Thread {
        final /* synthetic */ ThreadPool this$0;

        public PooledThread(ThreadPool threadPool) {
            StringBuffer stringBuffer = new StringBuffer("T");
            int n = threadId;
            threadId = n + 1;
            super((ThreadGroup)threadPool, stringBuffer.append(n).toString());
            this.this$0 = threadPool;
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 7[TRYBLOCK] [14 : 262->265)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public final class Closed
    extends RuntimeException {
        Closed() {
            super("Tried to execute operation on a clased ThreadPool.");
        }
    }
}

