/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Logger;
import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.secureweb.GPKISecureWEBException;
import java.io.Serializable;

public class GPKIKeyInfo
implements Serializable {
    private String algo = "";
    private String challenge = "";
    private boolean authType = false;
    private X509Certificate signerCert;
    private byte[] client_write_key;
    private byte[] client_write_iv;
    private byte[] server_write_key;
    private byte[] server_write_iv;

    public String getChallenge() {
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + " GPKIKeyInfo implements Serializable");
        return this.challenge;
    }

    public byte[] getClientKey() {
        return this.client_write_key;
    }

    public byte[] getClientIV() {
        return this.client_write_iv;
    }

    public byte[] getServerKey() {
        return this.server_write_key;
    }

    public byte[] getServerIV() {
        return this.server_write_iv;
    }

    public String getAlgo() {
        return this.algo;
    }

    public boolean getAuthType() {
        return this.authType;
    }

    public X509Certificate getSignerCert() {
        return this.signerCert;
    }

    public void setClientKey(byte[] byArray) throws GPKISecureWEBException {
        if (byArray == null) {
            throw new GPKISecureWEBException("Key value is not null!");
        }
        this.client_write_key = byArray;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 client_write_key : " + byArray);
    }

    public void setClientIV(byte[] byArray) throws GPKISecureWEBException {
        if (byArray == null) {
            throw new GPKISecureWEBException("IV value is not null!");
        }
        this.client_write_iv = byArray;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 client_write_iv : " + byArray);
    }

    public void setServerKey(byte[] byArray) throws GPKISecureWEBException {
        if (byArray == null) {
            throw new GPKISecureWEBException("Key value is not null!");
        }
        this.server_write_key = byArray;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 server_write_key : " + byArray);
    }

    public void setServerIV(byte[] byArray) throws GPKISecureWEBException {
        if (byArray == null) {
            throw new GPKISecureWEBException("IV value is not null!");
        }
        this.server_write_iv = byArray;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 server_write_iv : " + byArray);
    }

    public void setAlgo(String string) throws GPKISecureWEBException {
        if (string == null) {
            throw new GPKISecureWEBException("algo value is not null!");
        }
        this.algo = string;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 \uc54c\uace0\ub9ac\uc998 : " + string);
    }

    public void setChallenge(String string) throws GPKISecureWEBException {
        if (string == null) {
            throw new GPKISecureWEBException("challenge value is not null!");
        }
        this.challenge = string;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 challenge : " + string);
    }

    public void setAuthType(boolean bl) {
        this.authType = bl;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 authType : " + bl);
    }

    public void setSignerCert(X509Certificate x509Certificate) throws GPKISecureWEBException {
        if (x509Certificate == null) {
            throw new GPKISecureWEBException("signerCert value is not null!");
        }
        this.signerCert = x509Certificate;
        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIKeyInfo\uc5d0 \uc138\ud305\ub418\ub294 signerCert : " + x509Certificate);
    }
}

