/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Config;
import com.dsjdf.jdf.Configuration;
import com.dsjdf.jdf.ConfigurationException;
import com.dsjdf.jdf.Logger;
import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.storage.Disk;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.util.GPKIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class GPKISecureWEBConfig {
    private static GPKISecureWEBConfig gpkiConf;
    private static Config conf;
    static /* synthetic */ Class class$0;

    public static GPKISecureWEBConfig getInstance() throws GPKISecureWEBException {
        try {
            if (gpkiConf == null) {
                gpkiConf = new GPKISecureWEBConfig();
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return gpkiConf;
    }

    public GPKISecureWEBConfig() throws GPKISecureWEBException {
        try {
            conf = new Configuration();
        }
        catch (ConfigurationException e) {
            Logger.err.println(this, GPKIUtil.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
    }

    public static X509Certificate getServerCert() throws GPKISecureWEBException {
        X509Certificate cert = null;
        try {
            cert = Disk.readCert((String)conf.getString("GPKISecureWeb.CertFilePathName"));
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return cert;
    }

    public static PrivateKey getPrivateKey() throws GPKISecureWEBException {
        PrivateKey prikey;
        try {
            prikey = Disk.readPriKey((String)conf.getString("GPKISecureWeb.PrivateKeyFilePathName"), (String)conf.getString("GPKISecureWeb.PrivateKeyPasswd"));
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return prikey;
    }

    public static X509Certificate getServerSignCert() throws GPKISecureWEBException {
        X509Certificate cert = null;
        try {
            cert = Disk.readCert((String)conf.getString("GPKISecureWeb.SignCertFilePathName"));
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return cert;
    }

    public static PrivateKey getSignPrivateKey() throws GPKISecureWEBException {
        PrivateKey prikey;
        try {
            prikey = Disk.readPriKey((String)conf.getString("GPKISecureWeb.SignPrivateKeyFilePathName"), (String)conf.getString("GPKISecureWeb.SignPrivateKeyPasswd"));
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return prikey;
    }

    public static X509Certificate getNPKIServerCert() throws GPKISecureWEBException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.gpki.secureweb.GPKISecureWEBConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.info.println(clazz, "[" + Thread.currentThread().getName() + "] getNPKIServerCert() \ud568\uc218\ub294 \uc0ac\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        return null;
    }

    public static PrivateKey getNPKIPrivateKey() throws GPKISecureWEBException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.gpki.secureweb.GPKISecureWEBConfig");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Logger.info.println(clazz, "[" + Thread.currentThread().getName() + "] getNPKIPrivateKey() \ud568\uc218\ub294 \uc0ac\uc6a9\ub418\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
        return null;
    }

    public static String getAlgo() throws GPKISecureWEBException {
        try {
            return conf.getString("GPKISecureWeb.crypto.algo");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
    }

    public static String getGPKIAPIConfFilePath() throws GPKISecureWEBException {
        String GPKIConfFilePath = null;
        try {
            GPKIConfFilePath = conf.getString("GPKISecureWeb.gpkiapi.ConfFilePath");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return GPKIConfFilePath;
    }

    public static String getAnyPolicy() throws GPKISecureWEBException {
        String anyPolicy = null;
        try {
            anyPolicy = conf.getString("GPKISecureWeb.AnyPolicy");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return anyPolicy;
    }

    public static String getPolicies() throws GPKISecureWEBException {
        String policies = null;
        try {
            policies = conf.getString("GPKISecureWeb.Policy");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return policies;
    }

    public static String getCheckChallenge() throws GPKISecureWEBException {
        String confChallenge = null;
        try {
            confChallenge = conf.getString("GPKISecureWeb.CheckChallenge");
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return confChallenge;
    }

    public static String[] getVerifyCertMethod() {
        ArrayList<String> verifyCertMethodList = new ArrayList<String>(3);
        String verifyCertMethod = conf.getString("GPKISecureWeb.VerifyCertMethod");
        StringTokenizer st = new StringTokenizer(verifyCertMethod, "|");
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken().trim().toUpperCase();
            if (tmp.length() == 0) continue;
            if (!(tmp.equals("CRL") || tmp.equals("OCSP") || tmp.equals("IVS"))) {
                Logger.warn.println(gpkiConf, "[" + Thread.currentThread().getName() + "] \ud658\uacbd\uc124\uc815 \ud30c\uc77c \ub0b4 \uc778\uc99d\uc11c \uac80\uc99d\ud56d\ubaa9(GPKISecureWeb.VerifyCertMethod) \ub0b4 \uac12\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. (" + tmp + ")");
                continue;
            }
            verifyCertMethodList.add(tmp);
        }
        String[] verifyCertMethodArray = new String[verifyCertMethodList.size()];
        int i = 0;
        while (i < verifyCertMethodArray.length) {
            verifyCertMethodArray[i] = (String)verifyCertMethodList.get(i);
            ++i;
        }
        return verifyCertMethodArray;
    }

    public static X509Certificate[] getTrustedRootCert() throws GPKISecureWEBException {
        X509Certificate[] cert = null;
        ArrayList<X509Certificate> oCertList = new ArrayList<X509Certificate>(4);
        try {
            int cnt = 0;
            String sCount = conf.getString("GPKISecureWeb.TrustedROOTCACert.count");
            if (sCount.length() == 0) {
                throw new GPKISecureWEBException("\ud658\uacbd\uc124\uc815 \ubcc0\uc218 \ub0b4 \ucd5c\uc0c1\uc704 \uc778\uc99d\uae30\uad00 \uc778\uc99d\uc11c\uc758 \uac2f\uc218(GPKISecureWeb.TrustedROOTCACert.count)\uc758 \uac12\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
            }
            try {
                cnt = Integer.parseInt(sCount);
            }
            catch (NumberFormatException e) {
                throw new GPKISecureWEBException("\ud658\uacbd\uc124\uc815 \ubcc0\uc218 \ub0b4 \ucd5c\uc0c1\uc704 \uc778\uc99d\uae30\uad00 \uc778\uc99d\uc11c\uc758 \uac2f\uc218(GPKISecureWeb.TrustedROOTCACert.count)\uc758 \uac12\uc774 \uc22b\uc790\uac00 \uc544\ub2d9\ub2c8\ub2e4.");
            }
            Logger.debug.println(GPKISecureWEBConfig.getInstance(), "[" + Thread.currentThread().getName() + "] GPKISecureWeb.TrustedROOTCACert.count = " + cnt);
            if (cnt <= 0) {
                Logger.warn.println(GPKISecureWEBConfig.getInstance(), "[" + Thread.currentThread().getName() + "] \ud658\uacbd\uc124\uc815 \ubcc0\uc218 \ub0b4 \ucd5c\uc0c1\uc704 \uc778\uc99d\uae30\uad00 \uc778\uc99d\uc11c\uc758 \uac2f\uc218(GPKISecureWeb.TrustedROOTCACert.count)\uc758 \uac12\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
                throw new GPKISecureWEBException("\ud658\uacbd\uc124\uc815 \ubcc0\uc218 \ub0b4 \ucd5c\uc0c1\uc704 \uc778\uc99d\uae30\uad00 \uc778\uc99d\uc11c\uc758 \uac2f\uc218(GPKISecureWeb.TrustedROOTCACert.count)\uc758 \uac12\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
            }
            int idx = 1;
            int i = 0;
            while (i < cnt) {
                block14: {
                    String sFilePath = null;
                    try {
                        sFilePath = conf.getString("GPKISecureWeb.TrustedROOTCACert.FilePathName." + idx);
                    }
                    catch (Exception e) {
                        Logger.warn.println(GPKISecureWEBConfig.getInstance(), "[" + Thread.currentThread().getName() + "] GPKISecureWeb.TrustedROOTCACert.FilePathName." + idx + " \ud56d\ubaa9\uc774 \uc815\uc758\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
                        break block14;
                    }
                    if (sFilePath.length() == 0) {
                        Logger.warn.println(GPKISecureWEBConfig.getInstance(), "[" + Thread.currentThread().getName() + "] GPKISecureWeb.TrustedROOTCACert.FilePathName." + idx + " \uc758 \uac12\uc774 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4.");
                        ++idx;
                    } else {
                        File oFile = new File(sFilePath);
                        if (!oFile.exists()) {
                            Logger.warn.println(GPKISecureWEBConfig.getInstance(), "[" + Thread.currentThread().getName() + "] GPKISecureWeb.TrustedROOTCACert.FilePathName." + idx + " \uc5d0 \ub300\ud55c \ud30c\uc77c\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. (" + sFilePath + ")");
                            ++idx;
                        } else {
                            oCertList.add(Disk.readCert((String)sFilePath));
                            Logger.debug.println(GPKISecureWEBConfig.getInstance(), "[" + Thread.currentThread().getName() + "] GPKISecureWeb.TrustedROOTCACert.FilePathName." + idx + " = " + sFilePath);
                            ++idx;
                        }
                    }
                }
                ++i;
            }
            cert = new X509Certificate[oCertList.size()];
            i = 0;
            while (i < cert.length) {
                cert[i] = (X509Certificate)oCertList.get(i);
                ++i;
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return cert;
    }

    public static boolean getLogLevel(String sLevel) throws GPKISecureWEBException {
        if (sLevel == null) {
            throw new GPKISecureWEBException("LogLevel value is null");
        }
        String sLogLevel = sLevel.toLowerCase();
        if (!(sLogLevel.equals("sys") || sLogLevel.equals("err") || sLogLevel.equals("warn") || sLogLevel.equals("info") || sLogLevel.equals("debug") || sLogLevel.equals("dbwrap"))) {
            throw new GPKISecureWEBException("Invalid LogLevel [" + sLevel + "].");
        }
        String sLevelParam = "logger." + sLevel.toLowerCase() + ".trace";
        boolean isPrintable = conf.getBoolean(sLevelParam);
        return isPrintable;
    }
}

