/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb;

import com.dsjdf.jdf.Logger;
import com.dsjdf.jdf.Utility;
import com.gpki.gpkiapi.crypto.MessageDigest;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBConfig;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.util.GPKIUtil;

public class KDF {
    private byte[] master_secret;
    private byte[] client_message;
    private byte[] keyblock;
    private GPKIKeyInfo keyinfo;

    public void setBaseKey(SecretKey master_key, byte[] envelopData) throws GPKISecureWEBException {
        GPKISecureWEBConfig gpkiConf = GPKISecureWEBConfig.getInstance();
        try {
            byte[] key = master_key.getKey();
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF key : " + Dump.toHexString((byte[])key, (long)0L, (long)key.length));
            }
            byte[] iv = master_key.getIv();
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF iv : " + Dump.toHexString((byte[])iv, (long)0L, (long)iv.length));
            }
            this.master_secret = new byte[key.length + iv.length];
            System.arraycopy(key, 0, this.master_secret, 0, key.length);
            System.arraycopy(iv, 0, this.master_secret, key.length, iv.length);
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF master_secret : " + Dump.toHexString((byte[])this.master_secret, (long)0L, (long)this.master_secret.length));
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF client_message_before : " + Dump.toHexString((byte[])envelopData, (long)0L, (long)envelopData.length));
            }
            this.client_message = MessageDigest.getInstance((String)"MD5").digest(envelopData);
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] client_message : " + Dump.toHexString((byte[])this.client_message, (long)0L, (long)this.client_message.length));
            }
        }
        catch (Exception e) {
            Logger.err.println(this, GPKIUtil.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
    }

    private void generateKeyBlock(int block_size) throws GPKISecureWEBException {
        GPKISecureWEBConfig gpkiConf = GPKISecureWEBConfig.getInstance();
        try {
            MessageDigest md5 = MessageDigest.getInstance((String)"MD5");
            MessageDigest sha1 = MessageDigest.getInstance((String)"SHA1");
            MessageDigest sha256 = MessageDigest.getInstance((String)"SHA256");
            String[] str = new String[]{"A", "BB", "CCC", "DDDD"};
            int loop = block_size / 32;
            int i = 0;
            while (i < loop) {
                byte[] block = sha256.digest(md5.digest(Utility.concat(this.master_secret, sha1.digest(Utility.concat(str[i].getBytes(), Utility.concat(this.master_secret, this.client_message))))));
                this.keyblock = i == 0 ? block : Utility.concat(this.keyblock, block);
                ++i;
            }
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] keyblock : " + Dump.toHexString((byte[])this.keyblock, (long)0L, (long)this.keyblock.length));
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
    }

    public GPKIKeyInfo getGPKIKeyInfo() throws GPKISecureWEBException {
        try {
            if (this.keyinfo != null) {
                return this.keyinfo;
            }
            this.generateKeyBlock(128);
            this.keyinfo = new GPKIKeyInfo();
            this.keyblock2GPKIKeyInfo(this.keyinfo, GPKISecureWEBConfig.getAlgo());
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
        return this.keyinfo;
    }

    private void keyblock2GPKIKeyInfo(GPKIKeyInfo keyinfo, String algo) throws GPKISecureWEBException {
        GPKISecureWEBConfig gpkiConf = GPKISecureWEBConfig.getInstance();
        try {
            byte[] ckey = null;
            byte[] civ = null;
            byte[] skey = null;
            byte[] siv = null;
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] config\uc5d0 \uc138\ud305\ub418\uc5b4 \uc788\ub294  algo = " + algo);
            }
            if (algo.equals("NEAT/CBC") || algo.equals("SEED/CBC") || algo.equals("ARIA/CBC")) {
                ckey = new byte[16];
                civ = new byte[16];
                skey = new byte[16];
                siv = new byte[16];
            } else if (algo.equals("3DES/CBC")) {
                ckey = new byte[24];
                civ = new byte[8];
                skey = new byte[24];
                siv = new byte[8];
            } else if (algo.equals("NES/CBC")) {
                ckey = new byte[32];
                civ = new byte[32];
                skey = new byte[32];
                siv = new byte[32];
            } else {
                throw new GPKISecureWEBException("Not Supported Algorithm - " + GPKISecureWEBConfig.getGPKIAPIConfFilePath() + "GPKISecureWeb.properties file in algo" + " ::: " + "algo : " + algo);
            }
            System.arraycopy(this.keyblock, 0, ckey, 0, ckey.length);
            System.arraycopy(this.keyblock, ckey.length, civ, 0, civ.length);
            keyinfo.setClientKey(ckey);
            keyinfo.setClientIV(civ);
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF keyinfo.getClientKey() : " + Dump.toHexString((byte[])keyinfo.getClientKey(), (long)0L, (long)keyinfo.getClientKey().length));
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF keyinfo.getClientIV() : " + Dump.toHexString((byte[])keyinfo.getClientIV(), (long)0L, (long)keyinfo.getClientIV().length));
            }
            System.arraycopy(this.keyblock, ckey.length + civ.length, skey, 0, skey.length);
            System.arraycopy(this.keyblock, ckey.length + civ.length + skey.length, siv, 0, siv.length);
            keyinfo.setServerKey(skey);
            keyinfo.setServerIV(siv);
            keyinfo.setAlgo(algo);
            if (GPKISecureWEBConfig.getLogLevel("debug")) {
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF keyinfo.getServerKey() : " + Dump.toHexString((byte[])keyinfo.getServerKey(), (long)0L, (long)keyinfo.getServerKey().length));
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] KDF keyinfo.getServerIV() : " + Dump.toHexString((byte[])keyinfo.getServerIV(), (long)0L, (long)keyinfo.getServerIV().length));
            }
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
    }
}

