/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.secureweb.php;

import com.dsjdf.jdf.Logger;
import com.gpki.gpkiapi.GpkiApi;
import com.gpki.gpkiapi.cert.CertPathValidator;
import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.cms.SignedContent;
import com.gpki.gpkiapi.cms.SignedData;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.crypto.Random;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.ivs.VerifyCert;
import com.gpki.gpkiapi.util.Base64;
import com.gpki.gpkiapi.util.Dump;
import com.gpki.secureweb.Base64ContentInfo;
import com.gpki.secureweb.EncryptedData;
import com.gpki.secureweb.EnvelopData;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBConfig;
import com.gpki.secureweb.GPKISecureWEBDefine;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.secureweb.KDF;
import com.gpki.util.GPKIUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class GPKISecureWeb
implements GPKISecureWEBDefine {
    private String encryptData;
    private String decryptData;
    private GPKIKeyInfo keyinfo = new GPKIKeyInfo();
    private String messageType;
    private byte[] signData;
    private Hashtable paramMap;
    private byte[] privatekey_random;
    private String processLog = "";
    private X509Certificate signer_cert = null;
    private final byte CERT_VERIFY_SUCCESS = 0;
    private final byte CERT_VERIFY_FAIL = 1;

    public GPKISecureWeb(String encryptData, String algorithm, byte[] client_key, byte[] client_iv, byte[] server_key, byte[] server_iv, String challenge) {
        try {
            this.keyinfo.setClientKey(client_key);
            this.keyinfo.setClientIV(client_iv);
            this.keyinfo.setServerKey(server_key);
            this.keyinfo.setServerIV(server_iv);
            this.keyinfo.setAlgo(algorithm);
            this.keyinfo.setChallenge(challenge);
        }
        catch (GPKISecureWEBException e) {
            Logger.err.println(this, e.getMessage());
            e.getMessage();
        }
        this.encryptData = encryptData;
    }

    public String getParameter(String key) {
        List list = (List)this.paramMap.get(key);
        return (String)list.get(0);
    }

    public String[] getParameterValues(String key) {
        List list = (List)this.paramMap.get(key);
        String[] ret = new String[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)list.get(i);
            ++i;
        }
        return ret;
    }

    public String[] getParameterNames() {
        Enumeration keys = this.paramMap.keys();
        ArrayList list = new ArrayList(10);
        while (keys.hasMoreElements()) {
            list.add(keys.nextElement());
        }
        String[] ret = new String[list.size()];
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)list.get(i);
            ++i;
        }
        return ret;
    }

    public String getQueryString() {
        return this.decryptData;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getSignType() {
        String ret = "";
        int messageTypeTmp = Integer.parseInt(this.messageType);
        if (messageTypeTmp == 1 || messageTypeTmp == 23 || messageTypeTmp == 22 || messageTypeTmp == 20) {
            ret = "WIRE";
        } else if (messageTypeTmp == 33 || messageTypeTmp == 32 || messageTypeTmp == 30) {
            ret = "WIRELESS";
        }
        return ret;
    }

    public byte[] getSignedData() {
        return this.signData;
    }

    public String encrypt(String src) throws GPKISecureWEBException {
        String encData = null;
        EncryptedData enc = null;
        try {
            Logger.debug.println(this, "keyinfo = " + this.keyinfo);
            Logger.debug.println(this, "Algo = " + this.keyinfo.getAlgo());
            Logger.debug.println(this, "ServerKey = " + this.keyinfo.getServerKey());
            Logger.debug.println(this, "ServerIV = " + this.keyinfo.getServerIV());
            enc = new EncryptedData();
            enc.setKey(this.keyinfo.getAlgo(), this.keyinfo.getServerKey(), this.keyinfo.getServerIV());
            encData = enc.encrypt(src);
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e.getMessage());
        }
        return encData;
    }

    public String encrypt(int src) throws GPKISecureWEBException {
        return this.encrypt(String.valueOf(src));
    }

    public String getChallenge() throws GPKISecureWEBException {
        try {
            byte[] random = new Random().generateRandom(20);
            String challenge = new Base64().encode(random);
            this.keyinfo.setChallenge(challenge);
        }
        catch (GpkiApiException e) {
            Logger.err.println(this, e.getMessage());
            throw new GPKISecureWEBException(e.getMessage());
        }
        return this.keyinfo.getChallenge();
    }

    public byte[] getPrivateRandom() {
        return this.privatekey_random;
    }

    public GPKIKeyInfo getGPKIKeyInfo() {
        return this.keyinfo;
    }

    public void init() throws GPKISecureWEBException {
        block34: {
            this.paramMap = new Hashtable(20);
            try {
                GPKISecureWEBConfig conf = GPKISecureWEBConfig.getInstance();
                Logger.debug.println(this, "GPKISecureWEBConfig = " + conf.getClass().getName());
                GpkiApi.init((String)GPKISecureWEBConfig.getGPKIAPIConfFilePath());
                Logger.debug.println(this, "GpkiApi.init() = " + GPKISecureWEBConfig.getGPKIAPIConfFilePath());
                Logger.debug.println(this, "encryptData = " + this.encryptData);
                if (this.encryptData == null) {
                    return;
                }
                String query = this.encryptData;
                Base64ContentInfo base64info = new Base64ContentInfo(query);
                byte cType = base64info.getContentType();
                Logger.debug.println(this, "content_type = " + cType);
                this.messageType = String.valueOf(cType);
                if (cType != 20) {
                    // empty if block
                }
                if (cType == 0) {
                    try {
                        EncryptedData encdata = new EncryptedData(query);
                        Logger.debug.println(this, "keyinfo.getAlgo()==" + this.keyinfo.getAlgo());
                        Logger.debug.println(this, "keyinfo.getClientKey()==" + this.keyinfo.getClientKey());
                        encdata.setKey(this.keyinfo.getAlgo(), this.keyinfo.getClientKey(), this.keyinfo.getClientIV());
                        Logger.info.println(this, "key\uac12 \uc138\ud305 \uc644\ub8cc");
                        this.decryptData = new String(encdata.decrypt());
                        this.setDecrytData2Query(this.decryptData);
                        break block34;
                    }
                    catch (Exception e) {
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 1) {
                    try {
                        EncryptedData encdata = new EncryptedData(query);
                        encdata.setKey(this.keyinfo.getAlgo(), this.keyinfo.getClientKey(), this.keyinfo.getClientIV());
                        Logger.info.println(this, "key\uac12 \uc138\ud305 \uc644\ub8cc");
                        this.signData = encdata.decrypt();
                        SignedData signdata = new SignedData();
                        signdata.verify(this.signData);
                        Logger.info.println(this, "signdata.verify \uc218\ud589");
                        this.decryptData = new String(signdata.getMessage());
                        this.setDecrytData2Query(this.decryptData);
                        Logger.debug.println(this, "decryptData = " + this.decryptData);
                        int signer_cnt = signdata.getSignerCnt();
                        Logger.info.println(this, "signer_cnt = " + signer_cnt);
                        if (signer_cnt > 0) {
                            this.signer_cert = signdata.getSignerCert(signer_cnt - 1);
                            Logger.info.println(this, "signer_cert = " + this.signer_cert.getSubjectDN());
                            this.checkPolicy(this.signer_cert);
                            Logger.info.println(this, "\uc815\ucc45\uac80\uc99d \uc644\ub8cc ");
                            this.verifyCert(this.signer_cert);
                            Logger.info.println(this, "\uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc ");
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 2) {
                    try {
                        EncryptedData encdata = new EncryptedData(query);
                        encdata.setKey(this.keyinfo.getAlgo(), this.keyinfo.getClientKey(), this.keyinfo.getClientIV());
                        this.signData = encdata.decrypt();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signData : " + Dump.toHexString((byte[])this.signData, (long)0L, (long)this.signData.length));
                        SignedContent signedcontent = new SignedContent();
                        signedcontent.verify(this.signData);
                        this.decryptData = new String(signedcontent.getMessage());
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc6d0\ubcf8 \uba54\uc2dc\uc9c0 : " + Dump.toHexString((byte[])this.decryptData.getBytes(), (long)0L, (long)this.decryptData.getBytes().length));
                        this.setDecrytData2Query(this.decryptData);
                        this.signer_cert = signedcontent.getSignerCert();
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] signer_cert : " + this.signer_cert);
                        this.checkPolicy(this.signer_cert);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] checkPolicy \uc644\ub8cc");
                        this.verifyCert(this.signer_cert);
                        Logger.info.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc  : DN  [" + this.signer_cert.getSubjectDN() + "]");
                        break block34;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "[" + Thread.currentThread().getName() + "] ENCRYPTED_SIGNDATA Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 21 || cType == 31) {
                    try {
                        EnvelopData envelop_data = new EnvelopData(query);
                        this.decryptData = new String(envelop_data.decrypt());
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(this.keyinfo);
                        Logger.info.println(this, "challenge\uac12 \uccb4\ud06c \uc644\ub8cc");
                        KDF kdf = new KDF();
                        kdf.setBaseKey(envelop_data.secretkey, envelop_data.getContentInfo());
                        this.keyinfo = kdf.getGPKIKeyInfo();
                        break block34;
                    }
                    catch (Exception e) {
                        Logger.err.println(this, "EnvelopData Error : " + e.getMessage());
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 23) {
                    try {
                        KDF kdf = this.processEnvelopData(query);
                        Logger.info.println(this, "Key\uad50\ud658\uc744 \uc704\ud55c keyblock \uc0dd\uc131 \uc644\ub8cc");
                        SignedData signdata = new SignedData();
                        signdata.verify(this.signData);
                        Logger.info.println(this, "signdata.verify \uc218\ud589");
                        this.decryptData = new String(signdata.getMessage());
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(this.keyinfo);
                        Logger.info.println(this, "challenge\uac12 \uccb4\ud06c \uc644\ub8cc");
                        this.signer_cert = signdata.getSignerCert(0);
                        Logger.info.println(this, "\ud074\ub77c\uc774\uc5b8\ud2b8 \uc778\uc99d\uc11c DN : " + this.signer_cert.getSubjectDN());
                        this.checkPolicy(this.signer_cert);
                        Logger.info.println(this, "\uc815\ucc45\uac80\uc99d \uc644\ub8cc ");
                        this.verifyCert(this.signer_cert);
                        Logger.info.println(this, "\uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc ");
                        Logger.debug.println(this, "kdf.getGPKIKeyInfo() =" + kdf.getGPKIKeyInfo());
                        this.keyinfo = kdf.getGPKIKeyInfo();
                        Logger.debug.println(this, "getKeyInfo");
                        this.keyinfo.setSignerCert(this.signer_cert);
                        Logger.debug.println(this, "setSignerCert");
                        this.keyinfo.setAuthType(true);
                        Logger.debug.println(this, "setAuthType");
                        break block34;
                    }
                    catch (Exception e) {
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 22) {
                    try {
                        KDF kdf = this.processEnvelopData(query);
                        SignedData signdata = new SignedData();
                        signdata.verify(this.signData);
                        this.decryptData = new String(signdata.getMessage());
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(this.keyinfo);
                        int signer_cnt = signdata.getSignerCnt();
                        if (signer_cnt > 0) {
                            this.signer_cert = signdata.getSignerCert(signer_cnt - 1);
                            Logger.debug.println(this, "signer_cert : " + this.signer_cert);
                            this.checkPolicy(this.signer_cert);
                            Logger.debug.println(this, "checkPolicy \uc644\ub8cc");
                            this.verifyCert(this.signer_cert);
                            Logger.debug.println(this, "verifyCert \uc644\ub8cc");
                        }
                        this.keyinfo = kdf.getGPKIKeyInfo();
                        Logger.debug.println(this, "keyinfo==" + this.keyinfo);
                        break block34;
                    }
                    catch (Exception e) {
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 33 || cType == 32) {
                    try {
                        KDF kdf = this.processEnvelopData(query);
                        SignedContent signdata = new SignedContent();
                        signdata.verify(this.signData);
                        this.decryptData = new String(signdata.getMessage());
                        this.setDecrytData2Query(this.decryptData);
                        this.checkChallenge(this.keyinfo);
                        this.signer_cert = signdata.getSignerCert();
                        this.checkPolicy(this.signer_cert);
                        this.verifyCert(this.signer_cert);
                        this.keyinfo = kdf.getGPKIKeyInfo();
                        if (cType == 33) {
                            this.keyinfo.setSignerCert(this.signer_cert);
                            this.keyinfo.setAuthType(true);
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType == 20) {
                    try {
                        this.signData = base64info.getContentInfo();
                        SignedData signdata = new SignedData();
                        signdata.verify(this.signData);
                        this.decryptData = new String(signdata.getMessage());
                        int signer_cnt = signdata.getSignerCnt();
                        int i = 0;
                        while (i < signer_cnt) {
                            this.signer_cert = signdata.getSignerCert(i);
                            this.checkPolicy(this.signer_cert);
                            this.verifyCert(this.signer_cert);
                            ++i;
                        }
                        break block34;
                    }
                    catch (Exception e) {
                        throw new GPKISecureWEBException(e);
                    }
                }
                if (cType != 30) break block34;
                try {
                    this.signData = base64info.getContentInfo();
                    SignedContent signdata = new SignedContent();
                    signdata.verify(this.signData);
                    this.decryptData = new String(signdata.getMessage());
                    this.signer_cert = signdata.getSignerCert();
                    this.checkPolicy(this.signer_cert);
                    this.verifyCert(this.signer_cert);
                }
                catch (Exception e) {
                    throw new GPKISecureWEBException(e);
                }
            }
            catch (Exception e) {
                Logger.err.println(this, e.getMessage());
                throw new GPKISecureWEBException(e.getMessage());
            }
        }
    }

    private void setDecrytData2Query(String decryptData) {
        Logger.debug.println(this, "decryptData  =  " + decryptData);
        if (decryptData != null || !decryptData.equals("")) {
            StringTokenizer st = new StringTokenizer(decryptData, "&");
            while (st.hasMoreElements()) {
                String stValue = (String)st.nextElement();
                String key = stValue.substring(0, stValue.indexOf(61));
                String value = stValue.substring(stValue.indexOf(61) + 1);
                List<String> list = null;
                list = this.paramMap.containsKey(key) ? (List)this.paramMap.get(key) : new ArrayList<String>();
                list.add(value);
                this.paramMap.put(key, list);
            }
        }
        Logger.debug.println(this, "setDecrytData2Query end");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkChallenge(GPKIKeyInfo keyinfo) throws GPKISecureWEBException {
        String challenge = this.getParameter("challenge");
        try {
            try {
                if (GPKISecureWEBConfig.getCheckChallenge().equalsIgnoreCase("yes")) {
                    Logger.debug.println(this, "execute checkChallenge");
                    if (challenge == null) throw new GPKISecureWEBException("Replay chechk -> challenge is null or empty : " + challenge + " , " + keyinfo.getChallenge());
                    if (keyinfo.getChallenge().equals("")) {
                        throw new GPKISecureWEBException("Replay chechk -> challenge is null or empty : " + challenge + " , " + keyinfo.getChallenge());
                    }
                    if (!keyinfo.getChallenge().equals(challenge)) {
                        throw new GPKISecureWEBException("Replay attak.." + challenge + " " + keyinfo.getChallenge());
                    }
                }
            }
            catch (GPKISecureWEBException e) {
                Logger.err.println(this, e.getMessage());
                throw new GPKISecureWEBException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            keyinfo.setChallenge("");
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        keyinfo.setChallenge("");
    }

    private void checkPolicy(X509Certificate signer_cert) throws GPKISecureWEBException {
        try {
            if (GPKISecureWEBConfig.getAnyPolicy().equals("yes")) {
                String signer_policies = signer_cert.getCertPolicy();
                String config_policies = GPKISecureWEBConfig.getPolicies();
                Logger.info.println(this, "signer_policies : " + signer_policies + " ::: " + "config_policies : " + config_policies);
                ArrayList<String> confPolicyList = new ArrayList<String>(4);
                StringTokenizer signer_policies_token = new StringTokenizer(signer_policies, ",");
                StringTokenizer conf_policies_token = new StringTokenizer(config_policies, ",");
                while (conf_policies_token.hasMoreTokens()) {
                    confPolicyList.add(conf_policies_token.nextToken());
                }
                String oid = "";
                while (signer_policies_token.hasMoreTokens()) {
                    String token = signer_policies_token.nextToken();
                    if (!confPolicyList.contains(token)) continue;
                    oid = token;
                    break;
                }
                if (oid.equals("")) {
                    Logger.info.println(this, "\uc815\ucc45\uac80\uc99d \uc5d0\ub7ec - client cert policies : " + signer_policies + "- config_policies : " + config_policies);
                    throw new GPKISecureWEBException("CheckPolicy Error - client cert policies : " + signer_policies + "- config_policies : " + config_policies);
                }
            }
        }
        catch (Exception e) {
            Logger.err.println(this, e.getMessage());
            throw new GPKISecureWEBException(e);
        }
    }

    private void verifyCert(X509Certificate signer_cert) throws GPKISecureWEBException {
        try {
            GPKISecureWEBConfig conf = GPKISecureWEBConfig.getInstance();
            String[] verifyCertMethod = GPKISecureWEBConfig.getVerifyCertMethod();
            if (verifyCertMethod == null || verifyCertMethod.length == 0) {
                Logger.err.println(this, "[" + Thread.currentThread().getName() + "] \ud658\uacbd\uc124\uc815 \ud30c\uc77c \ub0b4 \uc778\uc99d\uc11c \uac80\uc99d\ud56d\ubaa9(GPKISecureWeb.VerifyCertMethod) \uc5d0 \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. ");
                throw new Exception("[" + Thread.currentThread().getName() + "] \ud658\uacbd\uc124\uc815 \ud30c\uc77c \ub0b4 \uc778\uc99d\uc11c \uac80\uc99d\ud56d\ubaa9(GPKISecureWeb.VerifyCertMethod) \uc5d0 \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. ");
            }
            String sVerifyCertMethod = "";
            int i = 0;
            while (i < verifyCertMethod.length) {
                sVerifyCertMethod = String.valueOf(sVerifyCertMethod) + verifyCertMethod[i] + "|";
                ++i;
            }
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \uc778\uc99d\uc11c \uac80\uc99d \ubc29\ubc95 : " + sVerifyCertMethod);
            i = 0;
            boolean bVerifySucess = true;
            while (i < verifyCertMethod.length) {
                String errCode;
                String errMsg;
                if (verifyCertMethod[i].equals("CRL") || verifyCertMethod[i].equals("OCSP")) {
                    Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] " + verifyCertMethod[i] + " \uc778\uc99d\uc11c \uac80\uc99d \uc2dc\uc791");
                    try {
                        CertPathValidator certPathValiditor = new CertPathValidator(String.valueOf(GPKISecureWEBConfig.getGPKIAPIConfFilePath()) + GPKIUtil.FILE_SEPARATOR + "gpkiapi.conf");
                        X509Certificate oOCSPSignCert = null;
                        PrivateKey oOCSPSignPriKey = null;
                        if (verifyCertMethod[i].equals("OCSP")) {
                            oOCSPSignCert = GPKISecureWEBConfig.getServerSignCert();
                            oOCSPSignPriKey = GPKISecureWEBConfig.getSignPrivateKey();
                            certPathValiditor.setMyCert(oOCSPSignCert, oOCSPSignPriKey);
                        }
                        X509Certificate[] oaTrustedRootSignCert = GPKISecureWEBConfig.getTrustedRootCert();
                        int k = 0;
                        while (k < oaTrustedRootSignCert.length) {
                            certPathValiditor.addTrustedRootCert(oaTrustedRootSignCert[i]);
                            ++k;
                        }
                        int iCheckOption = 2;
                        if (verifyCertMethod[i].equals("OCSP")) {
                            iCheckOption = 4;
                        }
                        certPathValiditor.setRevokationCheck(iCheckOption);
                        certPathValiditor.validate(1, signer_cert);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] " + verifyCertMethod[i] + " \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc");
                        bVerifySucess = false;
                    }
                    catch (Exception e) {
                        errMsg = "[" + Thread.currentThread().getName() + "] " + verifyCertMethod[i] + "\uc744 \uc774\uc6a9\ud55c \uc778\uc99d\uc11c \uac80\uc99d \uc2e4\ud328  : DN - [" + signer_cert.getSubjectDN() + "] : " + e.getMessage();
                        errCode = GPKIUtil.getErrCode(e);
                        if (errCode.equals("1215") || errCode.equals("1203") || errCode.equals("1233") || errCode.equals("1238")) {
                            Logger.err.println(this, errMsg);
                            throw new Exception(e.getMessage());
                        }
                        Logger.warn.println(this, errMsg);
                    }
                } else if (verifyCertMethod[i].equals("IVS")) {
                    Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ud1b5\ud569\uac80\uc99d\uc11c\ubc84(IVS) \uc778\uc99d\uc11c \uac80\uc99d \uc2dc\uc791");
                    try {
                        VerifyCert oVC = new VerifyCert(String.valueOf(GPKISecureWEBConfig.getGPKIAPIConfFilePath()) + "/gpkiapi.conf");
                        oVC.setMyCert(GPKISecureWEBConfig.getServerSignCert());
                        oVC.verify(signer_cert);
                        Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] \ud1b5\ud569\uac80\uc99d\uc11c\ubc84(IVS) \uc778\uc99d\uc11c \uac80\uc99d \uc644\ub8cc");
                        bVerifySucess = false;
                    }
                    catch (Exception e) {
                        errMsg = "[" + Thread.currentThread().getName() + "] \ud1b5\ud569\uac80\uc99d\uc11c\ubc84\ub97c \uc774\uc6a9\ud55c \uc744 \uc774\uc6a9\ud55c \uc778\uc99d\uc11c \uac80\uc99d \uc2e4\ud328  : DN - [" + signer_cert.getSubjectDN() + "] : " + e.getMessage();
                        errCode = GPKIUtil.getErrCode(e);
                        if (errCode.equals("1215") || errCode.equals("1203") || errCode.equals("1233") || errCode.equals("1238")) {
                            Logger.err.println(this, errMsg);
                            throw new Exception(e.getMessage());
                        }
                        Logger.warn.println(this, errMsg);
                    }
                } else {
                    Logger.warn.println(this, "[" + Thread.currentThread().getName() + "] \ud658\uacbd\uc124\uc815 \ud30c\uc77c \ub0b4 \uc778\uc99d\uc11c \uac80\uc99d\ud56d\ubaa9(GPKISecureWeb.VerifyCertMethod) \ub0b4 \uac12\uc774 \uc62c\ubc14\ub974\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. (" + verifyCertMethod[i] + ")");
                }
                if (!bVerifySucess) break;
                ++i;
            }
            if (bVerifySucess) {
                throw new Exception(String.valueOf(sVerifyCertMethod) + " \ub97c \uc774\uc6a9\ud55c \uc778\uc99d\uc11c \uac80\uc99d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
        }
        catch (Exception e) {
            Logger.err.println(this, "[" + Thread.currentThread().getName() + "] verifyCert() Error : " + GPKIUtil.getStackTrace(e));
            throw new GPKISecureWEBException(e);
        }
    }

    private KDF processEnvelopData(String s) throws GPKISecureWEBException {
        try {
            EnvelopData envelop_data = new EnvelopData(s);
            this.signData = envelop_data.decrypt();
            this.privatekey_random = envelop_data.getPrivateKeyRandom();
            KDF kdf = new KDF();
            kdf.setBaseKey(envelop_data.secretkey, envelop_data.getContentInfo());
            Logger.info.println(this, "key\uac12 \uc138\ud305 \uc644\ub8cc");
            return kdf;
        }
        catch (Exception e) {
            throw new GPKISecureWEBException(e);
        }
    }

    public String getProcessLog() {
        return this.processLog;
    }

    public X509Certificate getSignerCert() {
        return this.signer_cert;
    }
}

