/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.servlet;

import com.dsjdf.jdf.Logger;
import com.gpki.gpkiapi.crypto.Random;
import com.gpki.gpkiapi.util.Base64;
import com.gpki.io.GPKIPrintWriter;
import com.gpki.io.GPKIServletOutputStream;
import com.gpki.secureweb.GPKIKeyInfo;
import com.gpki.secureweb.GPKISecureWEBException;
import com.gpki.servlet.GPKIHttpServletRequest;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class GPKIHttpServletResponse
implements HttpServletResponse {
    private HttpServletResponse res;
    private HttpServletRequest request;

    public GPKIHttpServletResponse() {
    }

    public GPKIHttpServletResponse(HttpServletResponse res) {
        this.res = res;
    }

    public void addCookie(Cookie cookie) {
        this.res.addCookie(cookie);
    }

    public boolean containsHeader(String arg0) {
        return this.res.containsHeader(arg0);
    }

    public String encodeURL(String arg0) {
        return this.res.encodeURL(arg0);
    }

    public String encodeRedirectURL(String arg0) {
        return this.res.encodeRedirectURL(arg0);
    }

    public String encodeUrl(String arg0) {
        return this.res.encodeUrl(arg0);
    }

    public String encodeRedirectUrl(String arg0) {
        return this.res.encodeRedirectUrl(arg0);
    }

    public void sendError(int arg0, String arg1) throws IOException {
        this.res.sendError(arg0, arg1);
    }

    public void sendError(int arg0) throws IOException {
        this.res.sendError(arg0);
    }

    public void sendRedirect(String arg0) throws IOException {
        this.res.sendRedirect(arg0);
    }

    public void setDateHeader(String arg0, long arg1) {
        this.res.setDateHeader(arg0, arg1);
    }

    public void addDateHeader(String arg0, long arg1) {
        this.res.addDateHeader(arg0, arg1);
    }

    public void setHeader(String arg0, String arg1) {
        this.res.addHeader(arg0, arg1);
    }

    public void addHeader(String arg0, String arg1) {
        this.res.addHeader(arg0, arg1);
    }

    public void setIntHeader(String arg0, int arg1) {
        this.res.setIntHeader(arg0, arg1);
    }

    public void addIntHeader(String arg0, int arg1) {
        this.res.addIntHeader(arg0, arg1);
    }

    public void setStatus(int arg0) {
        this.res.setStatus(arg0);
    }

    public void setStatus(int arg0, String arg1) {
        this.res.setStatus(arg0, arg1);
    }

    public String getCharacterEncoding() {
        return this.res.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        HttpSession session = this.request.getSession(false);
        GPKIKeyInfo keyinfo = (GPKIKeyInfo)session.getAttribute("GPKISession");
        return new GPKIServletOutputStream(this.res.getOutputStream(), keyinfo);
    }

    public PrintWriter getWriter() throws IOException {
        HttpSession session = this.request.getSession(false);
        GPKIKeyInfo keyinfo = (GPKIKeyInfo)session.getAttribute("GPKISession");
        return new GPKIPrintWriter((Writer)this.res.getWriter(), keyinfo);
    }

    public String getChallenge() throws GPKISecureWEBException {
        String challenge = null;
        try {
            HttpSession session = this.request.getSession(true);
            byte[] random = new Random().generateRandom(20);
            GPKIKeyInfo keyinfo = (GPKIKeyInfo)session.getAttribute("GPKISession");
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletResponse SessionID(session) : " + session.getId());
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletResponse SessionID(request) : " + this.request.getSession().getId());
            Logger.debug.println(this, "AttributeNames \ubfcc\ub9ac\uae30 \uc2dc\uc791");
            Enumeration e1 = session.getAttributeNames();
            while (e1.hasMoreElements()) {
                String attVale = (String)e1.nextElement();
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletResponse AttributeNames : " + attVale);
                Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletResponse AttributeValue : " + session.getAttribute(attVale));
            }
            Logger.debug.println(this, "AttributeNames \ubfcc\ub9ac\uae30 \ub05d");
            if (keyinfo == null) {
                keyinfo = new GPKIKeyInfo();
            }
            challenge = new Base64().encode(random);
            keyinfo.setChallenge(challenge);
            session.setAttribute("GPKISession", (Object)keyinfo);
            Logger.debug.println(this, "[" + Thread.currentThread().getName() + "] GPKIHttpServletResponse challenge = " + challenge);
        }
        catch (Exception e) {
            Logger.err.println(this, e.getMessage());
            throw new GPKISecureWEBException(e);
        }
        return challenge;
    }

    public void setContentLength(int arg0) {
        this.res.setContentLength(arg0);
    }

    public void setContentType(String arg0) {
        this.res.setContentType(arg0);
    }

    public void setBufferSize(int arg0) {
        this.res.setBufferSize(arg0);
    }

    public int getBufferSize() {
        return this.res.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        this.res.flushBuffer();
    }

    public void resetBuffer() {
        this.res.resetBuffer();
    }

    public boolean isCommitted() {
        return this.res.isCommitted();
    }

    public void reset() {
        this.res.reset();
    }

    public void setLocale(Locale arg0) {
        this.res.setLocale(arg0);
    }

    public Locale getLocale() {
        return this.res.getLocale();
    }

    public void setRequest(GPKIHttpServletRequest request) {
        this.request = request;
    }
}

