/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cert;

import com.gpki.gpkiapi.crypto.PublicKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.util.Pem;
import com.gpki.gpkiapi_jni;
import java.math.BigInteger;
import java.util.Date;

public class X509Certificate {
    private byte[] cert = null;
    private int intBuff = 0;
    private long longBuff = 0L;
    private byte[] binBuff = null;
    private String strBuff = "";
    private byte[] errBuff;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public X509Certificate(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        this.cert = byArray;
        this.gpkiapi.CERT_Load(byArray);
    }

    public X509Certificate(String string) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        Pem pem = new Pem();
        this.cert = pem.decode(string);
        this.gpkiapi.CERT_Load(this.cert);
    }

    public byte[] getCert() {
        return this.cert;
    }

    public String getPemCert() throws GpkiApiException {
        Pem pem = new Pem();
        return pem.encode(2, this.cert);
    }

    public void verifyVID(String string, byte[] byArray) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The idn is empty. You must input a value for it.");
        }
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The random is empty. You must input a value for it.");
        }
        if (this.gpkiapi.VID_Verify(this.cert, byArray, string) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public BigInteger getSerialNumber() throws GpkiApiException {
        if (this._getSerialNumber(this.cert) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
        BigInteger bigInteger = new BigInteger(this.binBuff);
        return bigInteger;
    }

    public String getIssuerDN() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetIssuerName() > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.sReturnString;
    }

    public Date getNotBefore() throws GpkiApiException {
        if (this._getNotBefore(this.cert) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
        Date date = new Date(this.longBuff * 1000L);
        return date;
    }

    public Date getNotAfter() throws GpkiApiException {
        if (this._getNotAfter(this.cert) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
        Date date = new Date(this.longBuff * 1000L);
        return date;
    }

    public String getSubjectDN() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetSubjectName() > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.sReturnString;
    }

    public String getSubjectUID() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetUID() > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.sReturnString;
    }

    public PublicKey getSubjectPublicKeyInfo() throws GpkiApiException {
        if (this._getSubjectPublicKeyInfo(this.cert) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
        PublicKey publicKey = new PublicKey(this.binBuff);
        return publicKey;
    }

    public String getKeyUsage() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetKeyUsage() > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.sReturnString;
    }

    public String getBasicConstsraints() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetBasicConstraints() > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.sReturnString;
    }

    public String getCertPolicy() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetCertPolicyID() > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.sReturnString;
    }

    public int getRemainDays() throws GpkiApiException {
        if (this.gpkiapi.CERT_GetRemainDays(this.cert) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.nReturnInt;
    }

    public int getRemainDays(int n) throws GpkiApiException {
        if (this.gpkiapi.CERT_GetRemainDays(this.cert, n) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.nReturnInt;
    }

    private native int _getSerialNumber(byte[] var1);

    private native int _getNotBefore(byte[] var1);

    private native int _getNotAfter(byte[] var1);

    private native int _getSubjectPublicKeyInfo(byte[] var1);
}

