/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cms;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.crypto.SecretKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class EnvelopedData {
    public static int OPT_USE_RSA_V15 = 1;
    public static int OPT_USE_CONTENT_INFO = 2;
    int algCode;
    byte[] recCerts;
    byte[] recCert;
    byte[] key;
    byte[] iv;
    int option;
    gpkiapi_jni gpkiapi;

    public EnvelopedData() throws GpkiApiException {
        this("SEED", 0);
    }

    public EnvelopedData(int n) throws GpkiApiException {
        this("SEED", n);
    }

    public EnvelopedData(String string) throws GpkiApiException {
        this(string, 0);
    }

    public EnvelopedData(String string, int n) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        this.gpkiapi = new gpkiapi_jni();
        this.algCode = Algorithm.getSecretKeyAlg(string);
        if ((n & OPT_USE_RSA_V15) != 0) {
            this.option = gpkiapi_jni.API_OPT_RSA_ENC_V15;
        }
        if ((n & OPT_USE_CONTENT_INFO) != 0) {
            this.option |= gpkiapi_jni.API_OPT_CMS_CONTENT_INFO;
        }
        if (this.option != 0) {
            this.gpkiapi.API_SetOption(this.option);
        }
    }

    public void addRecipient(X509Certificate x509Certificate) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CERT_AddCert(x509Certificate.getCert()) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        this.recCert = x509Certificate.getCert();
        this.recCerts = this.gpkiapi.baReturnArray;
    }

    public byte[] generate(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The msg is null. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_MakeEnvelopedDataWithMultiRecipients(this.recCerts, byArray, Algorithm.code2id(this.algCode)) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void generate_File(String string, String string2) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The msgFilePath is null. You must input a value for it.");
        }
        if (string2.length() == 0) {
            throw new GpkiApiException("The envDataFilePath is null. You must input a value for it.");
        }
        if (this.recCert == null || this.recCert.length == 0) {
            throw new GpkiApiException("The recCert is empty. You must set recipient certificate.");
        }
        if (this.gpkiapi.CMS_MakeEnvelopedData_File(this.recCert, string, Algorithm.code2id(this.algCode), string2) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public void generate_noConetnt_File(String string, String string2, String string3) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The msgFilePath is null. You must input a value for it.");
        }
        if (string2.length() == 0) {
            throw new GpkiApiException("The envDataFilePath is null. You must input a value for it.");
        }
        if (string3.length() == 0) {
            throw new GpkiApiException("The encFilePath is null. You must input a value for it.");
        }
        if (this.recCert == null || this.recCert.length == 0) {
            throw new GpkiApiException("The recCert is empty. You must set recipient certificate.");
        }
        if (this.gpkiapi.CMS_MakeEnvelopedData_NoContent_File(this.recCert, string, Algorithm.code2id(this.algCode), string2, string3) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public byte[] process(byte[] byArray, X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The envData is null. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is null. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is null. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_ProcessEnvelopedData(x509Certificate.getCert(), privateKey.getKey(), byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public byte[] process_File(String string, X509Certificate x509Certificate, PrivateKey privateKey, String string2) throws GpkiApiException {
        this.process_File2(string, x509Certificate, privateKey, string2);
        return null;
    }

    public void process_File2(String string, X509Certificate x509Certificate, PrivateKey privateKey, String string2) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The envDataFilePath is null. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is null. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is null. You must input a value for it.");
        }
        if (string2.length() == 0) {
            throw new GpkiApiException("The msgFilePath is null. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_ProcessEnvelopedData_File(x509Certificate.getCert(), privateKey.getKey(), string, string2) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public void process_noContent_File(String string, String string2, X509Certificate x509Certificate, PrivateKey privateKey, String string3) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The envDataFilePath is null. You must input a value for it.");
        }
        if (string2.length() == 0) {
            throw new GpkiApiException("The encFilePath is null. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is null. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is null. You must input a value for it.");
        }
        if (string3.length() == 0) {
            throw new GpkiApiException("The msgFilePath is null. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_ProcessEnvelopedData_NoContent_File(x509Certificate.getCert(), privateKey.getKey(), string, string2, string3) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public SecretKey getSecretKey() throws GpkiApiException {
        String string = "";
        if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_SEED_CBC) {
            string = "SEED";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_DES_CBC) {
            string = "DES";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_3DES_CBC) {
            string = "3DES";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_NEAT_CBC) {
            string = "NEAT";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_ARIA_CBC) {
            string = "ARIA";
        } else if (this.gpkiapi.nSymAlg == gpkiapi_jni.SYM_ALG_NES_CBC) {
            string = "NES";
        } else {
            throw new GpkiApiException("Unknown secret algorithm(" + this.gpkiapi.nSymAlg + ")");
        }
        SecretKey secretKey = new SecretKey(string, this.gpkiapi.baKey, this.gpkiapi.baIV);
        return secretKey;
    }
}

