/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cms;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;
import java.util.Calendar;
import java.util.Date;

public class SignedContent {
    private byte[] outBuff = null;
    private byte[] msgBuff = null;
    private byte[] certBuff = null;
    private byte[] errBuff;
    private String signTime = "";
    private long genTime = 0L;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public void setSignTime(Date date) throws GpkiApiException {
        if (date == null) {
            throw new GpkiApiException("The time is null. You must input a value for it.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.signTime = this.signTime + calendar.get(1);
        switch (calendar.get(2)) {
            case 0: {
                this.signTime = this.signTime + "01";
                break;
            }
            case 1: {
                this.signTime = this.signTime + "02";
                break;
            }
            case 2: {
                this.signTime = this.signTime + "03";
                break;
            }
            case 3: {
                this.signTime = this.signTime + "04";
                break;
            }
            case 4: {
                this.signTime = this.signTime + "05";
                break;
            }
            case 5: {
                this.signTime = this.signTime + "06";
                break;
            }
            case 6: {
                this.signTime = this.signTime + "07";
                break;
            }
            case 7: {
                this.signTime = this.signTime + "08";
                break;
            }
            case 8: {
                this.signTime = this.signTime + "09";
                break;
            }
            case 9: {
                this.signTime = this.signTime + "10";
                break;
            }
            case 10: {
                this.signTime = this.signTime + "11";
                break;
            }
            case 11: {
                this.signTime = this.signTime + "12";
            }
        }
        int n = calendar.get(5);
        if (n < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n;
        int n2 = calendar.get(11);
        if (n2 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n2;
        int n3 = calendar.get(12);
        if (n3 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n3;
        int n4 = calendar.get(13);
        if (n4 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n4;
    }

    public byte[] generate(byte[] byArray, X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The msg is null. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this.gpkiapi.WCMS_MakeSignedContent(x509Certificate.getCert(), privateKey.getKey(), byArray, this.signTime) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void verify(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The signedContent is empty. You must input a value for it.");
        }
        if (this._verify(byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public byte[] getMessage() {
        return this.msgBuff;
    }

    public X509Certificate getSignerCert() throws GpkiApiException {
        X509Certificate x509Certificate = new X509Certificate(this.certBuff);
        return x509Certificate;
    }

    public Date getSigningTime() throws GpkiApiException {
        Date date = new Date(this.genTime * 1000L);
        return date;
    }

    private native int _verify(byte[] var1);
}

