/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.cms;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.tsa.TimeStampToken;
import com.gpki.gpkiapi_jni;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;

public class SignedData {
    public static final int OPT_USE_CONTENT_INFO = 1;
    public static final int OPT_USE_SET_CAPUBS = 2;
    byte[] outBuff;
    byte[] msgBuff;
    byte[] errBuff;
    String signTime = "";
    String msgFilePathBuff = "";
    String confFilePath;
    ArrayList certArray;
    ArrayList tbtArray;
    ArrayList tstArray;
    long[] timeArray;
    int cntBuff;
    int option;
    byte[] capubs;
    int nHash = 0;
    gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public SignedData() {
        this(0);
    }

    public SignedData(int n) {
        if ((n & 1) != 0) {
            this.option = gpkiapi_jni.API_OPT_CMS_CONTENT_INFO;
        }
        if ((n & 2) != 0) {
            this.option |= gpkiapi_jni.API_OPT_CMS_SET_CAPUBS;
        }
        if (this.option != 0) {
            this.gpkiapi.API_SetOption(this.option);
        }
    }

    public void setConfFile(String string) {
        this.gpkiapi.API_SetConfFile(string);
    }

    public void setCaPubs(byte[] byArray) {
        this.gpkiapi.API_SetCaPubs(byArray);
    }

    public void setHashAlgo(String string) throws GpkiApiException {
        this.nHash = Algorithm.code2id(Algorithm.getHashAlg(string));
        if (this.nHash == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + this.nHash + ")");
        }
        this.gpkiapi.API_SetHashAlgo(this.nHash);
    }

    public void setMessage(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The msg is null. You must input a value for it.");
        }
        this.msgBuff = byArray;
    }

    public void setMessage_File(String string) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The file path is null. You must input a value for it.");
        }
        this.msgFilePathBuff = string;
    }

    public void setSignTime(Date date) throws GpkiApiException {
        if (date == null) {
            throw new GpkiApiException("The time is null. You must input a value for it.");
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.signTime = this.signTime + calendar.get(1);
        switch (calendar.get(2)) {
            case 0: {
                this.signTime = this.signTime + "01";
                break;
            }
            case 1: {
                this.signTime = this.signTime + "02";
                break;
            }
            case 2: {
                this.signTime = this.signTime + "03";
                break;
            }
            case 3: {
                this.signTime = this.signTime + "04";
                break;
            }
            case 4: {
                this.signTime = this.signTime + "05";
                break;
            }
            case 5: {
                this.signTime = this.signTime + "06";
                break;
            }
            case 6: {
                this.signTime = this.signTime + "07";
                break;
            }
            case 7: {
                this.signTime = this.signTime + "08";
                break;
            }
            case 8: {
                this.signTime = this.signTime + "09";
                break;
            }
            case 9: {
                this.signTime = this.signTime + "10";
                break;
            }
            case 10: {
                this.signTime = this.signTime + "11";
                break;
            }
            case 11: {
                this.signTime = this.signTime + "12";
            }
        }
        int n = calendar.get(5);
        if (n < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n;
        int n2 = calendar.get(11);
        if (n2 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n2;
        int n3 = calendar.get(12);
        if (n3 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n3;
        int n4 = calendar.get(13);
        if (n4 < 10) {
            this.signTime = this.signTime + "0";
        }
        this.signTime = this.signTime + n4;
    }

    public byte[] generate(X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_MakeSignedData(x509Certificate.getCert(), privateKey.getKey(), this.msgBuff, this.signTime) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void generate_File(X509Certificate x509Certificate, PrivateKey privateKey, String string) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this._signData_File(x509Certificate.getCert(), privateKey.getKey(), this.msgFilePathBuff, this.nHash, this.signTime, string, false, this.option) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public void generate_noContent_File(X509Certificate x509Certificate, PrivateKey privateKey, String string) throws GpkiApiException {
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this._signData_File(x509Certificate.getCert(), privateKey.getKey(), this.msgFilePathBuff, this.nHash, this.signTime, string, true, this.option) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public byte[] addSigner(byte[] byArray, X509Certificate x509Certificate, PrivateKey privateKey) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The signedData is empty. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The signCert is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CMS_MakeSignedDataWithAddSigner(x509Certificate.getCert(), privateKey.getKey(), byArray, this.signTime) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void verify(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The signedData is empty. You must input a value for it.");
        }
        if (this._verify(this.msgBuff, byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public void verify_File(String string, String string2) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The signedDataFilePath is empty. You must input a value for it.");
        }
        if (string.length() == 0) {
            throw new GpkiApiException("The msgFilePath is empty. You must input a value for it.");
        }
        if (this._verify_File(string, string2, false) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public void verify_noContetn_File(String string, String string2) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The signedDataFilePath is empty. You must input a value for it.");
        }
        if (string.length() == 0) {
            throw new GpkiApiException("The msgFilePath is empty. You must input a value for it.");
        }
        if (this._verify_File(string, string2, true) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public byte[] getMessage() {
        return this.msgBuff;
    }

    public int getSignerCnt() {
        return this.cntBuff;
    }

    public X509Certificate getSignerCert(int n) throws GpkiApiException {
        if (n < 0) {
            throw new GpkiApiException("The index is negative.");
        }
        X509Certificate x509Certificate = new X509Certificate((byte[])this.certArray.get(n));
        return x509Certificate;
    }

    public byte[] getCaPubs() {
        return this.capubs;
    }

    public Date getSigningTime(int n) throws GpkiApiException {
        if (n < 0) {
            throw new GpkiApiException("The index is negative.");
        }
        Date date = new Date(this.timeArray[n] * 1000L);
        return date;
    }

    public byte[] getTBTData(int n) throws GpkiApiException {
        if (n < 0) {
            throw new GpkiApiException("The index is negative.");
        }
        byte[] byArray = (byte[])this.tbtArray.get(n);
        if (byArray == null) {
            return null;
        }
        return byArray;
    }

    public TimeStampToken getTimeStampToken(int n) throws GpkiApiException {
        if (n < 0) {
            throw new GpkiApiException("The index is negative.");
        }
        byte[] byArray = (byte[])this.tstArray.get(n);
        if (byArray == null) {
            return null;
        }
        return new TimeStampToken(byArray);
    }

    public byte[] setTimeStampToken(byte[] byArray, int n, TimeStampToken timeStampToken) throws GpkiApiException {
        if (this._setTimeStampToken(byArray, n, timeStampToken.getTimeStampToken()) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
        return this.outBuff;
    }

    protected void setSignerCert(int n, int n2, byte[] byArray, long l, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (n == 0) {
            this.timeArray = new long[n2];
            this.certArray = new ArrayList();
            this.tbtArray = new ArrayList();
            this.tstArray = new ArrayList();
            this.cntBuff = n2;
            this.capubs = byArray4;
        }
        this.timeArray[n] = l;
        this.certArray.add(byArray);
        this.tbtArray.add(byArray2);
        this.tstArray.add(byArray3);
    }

    private native int _verify(byte[] var1, byte[] var2);

    private native int _signData_File(byte[] var1, byte[] var2, String var3, int var4, String var5, String var6, boolean var7, int var8);

    private native int _verify_File(String var1, String var2, boolean var3);

    private native int _setTimeStampToken(byte[] var1, int var2, byte[] var3);
}

