/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Key;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class PrivateKey
implements Key {
    private String keyAlg = "";
    private String keyLen = "";
    private byte[] prikey = null;
    private byte[] errBuff;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public PrivateKey(byte[] byArray) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The prikey is empty. You must input a value for it.");
        }
        if (this._parsePrivateKey(byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
        this.prikey = byArray;
    }

    public String getKeyAlg() {
        return this.keyAlg;
    }

    public String getKeyLen() {
        return this.keyLen;
    }

    public byte[] getKey() {
        return this.prikey;
    }

    public byte[] getRandomForVID() throws GpkiApiException {
        if (this.gpkiapi.VID_GetRandomFromPriKey(this.prikey) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    private native int _parsePrivateKey(byte[] var1);
}

