/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.crypto;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.Key;
import com.gpki.gpkiapi.exception.GpkiApiException;

public class SecretKey
implements Key {
    private String keyAlg = "";
    private byte[] key = null;
    private byte[] iv = null;
    private byte[] changedKey = null;
    private byte[] changedIv = null;

    public SecretKey(String string, byte[] byArray, byte[] byArray2) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The key is empty. You must input a value for it.");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new GpkiApiException("The iv is empty. You must input a value for it.");
        }
        int n = Algorithm.getSecretKeyAlg(string);
        if (n == 0) {
            throw new GpkiApiException("Unknown algorithm. (input :" + string + ")");
        }
        this.keyAlg = string;
        this.key = byArray;
        this.iv = byArray2;
    }

    public void setKeyAndIv(byte[] byArray, byte[] byArray2) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The key is empty. You must input a value for it.");
        }
        if (byArray2 == null || byArray2.length == 0) {
            throw new GpkiApiException("The iv is empty. You must input a value for it.");
        }
        this.iv = byArray2;
        this.key = byArray;
        this.changedKey = null;
        this.changedIv = null;
    }

    public String getKeyAlg() {
        return this.keyAlg;
    }

    public byte[] getKey() {
        if (this.changedKey != null) {
            return this.changedKey;
        }
        return this.key;
    }

    public byte[] getIv() {
        if (this.changedIv != null) {
            return this.changedIv;
        }
        return this.iv;
    }

    protected void setChangedKeyAndIV(byte[] byArray, byte[] byArray2) {
        this.changedKey = byArray;
        this.changedIv = byArray2;
    }
}

