/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.ivs;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class VerifyCert {
    private String confFile = "";
    private byte[] myCert = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public VerifyCert(String string) {
        this.confFile = string;
    }

    public void setMyCert(X509Certificate x509Certificate) throws GpkiApiException {
        if (x509Certificate == null || x509Certificate.getCert().length == 0) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        this.myCert = x509Certificate.getCert();
    }

    public void verify(X509Certificate x509Certificate) throws GpkiApiException {
        if (x509Certificate == null || x509Certificate.getCert().length == 0) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (this.gpkiapi.CERT_VerifyByIVS(this.confFile, x509Certificate.getCert(), this.myCert) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }
}

