/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.ocsp;

import com.gpki.gpkiapi.cert.RevReason;
import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi.ocsp.OCSPRequest;
import com.gpki.gpkiapi_jni;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class OCSPResponse {
    public static int CERT_STATUS_VALID = 1;
    public static int CERT_STATUS_REVOKED = 2;
    public static int CERT_STATUS_HOLDED = 3;
    public static int CERT_STATUS_UNKNOWN = 4;
    byte[] errBuff;
    byte[] svrCert;
    byte[] resMsg;
    int[] status;
    String[] revDate;
    int[] reason;

    public OCSPResponse(byte[] byArray, OCSPRequest oCSPRequest) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The response is empty. You must input a value for it.");
        }
        this.resMsg = byArray;
        if (this._processResMsg(byArray, oCSPRequest.getNonce()) > 0) {
            throw new GpkiApiException(new gpkiapi_jni().byteArray2String(this.errBuff));
        }
    }

    public OCSPResponse(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The response is empty. You must input a value for it.");
        }
        this.resMsg = byArray;
    }

    protected OCSPResponse(String string, int n, byte[] byArray) {
        if (string.length() == 0) {
            this.setSingleCertStat(1, 0, 0, string, n);
        } else {
            this.setSingleCertStat(1, 0, 1, string, n);
        }
        this.svrCert = byArray;
    }

    public void verify(byte[] byArray) throws GpkiApiException {
        if (byArray == null) {
            throw new GpkiApiException("The reqMsg is empty. You must input a value for it.");
        }
        if (this._verify(byArray, this.resMsg) > 0) {
            throw new GpkiApiException(new gpkiapi_jni().byteArray2String(this.errBuff));
        }
    }

    public int getCertStatus() {
        return this.getCertStatus(0);
    }

    public Date getRevokedDate() throws ParseException {
        return this.getRevokedDate(0);
    }

    public RevReason getRevocationReason() {
        return this.getRevocationReason(0);
    }

    public int getSingleCertStatCnt() {
        return this.status.length;
    }

    public int getCertStatus(int n) {
        switch (this.status[n]) {
            case 0: {
                return CERT_STATUS_VALID;
            }
            case 1: {
                if (this.reason[n] == 6) {
                    return CERT_STATUS_HOLDED;
                }
                return CERT_STATUS_REVOKED;
            }
            case 2: {
                return CERT_STATUS_UNKNOWN;
            }
        }
        return 0;
    }

    public Date getRevokedDate(int n) throws ParseException {
        if (this.revDate[n] == null || this.revDate[n].length() == 0) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.revDate[n]);
    }

    public RevReason getRevocationReason(int n) {
        if (this.status[n] != 1) {
            return null;
        }
        return RevReason.getInstance(this.reason[n]);
    }

    public X509Certificate getOcspSvrCert() throws GpkiApiException {
        X509Certificate x509Certificate = new X509Certificate(this.svrCert);
        return x509Certificate;
    }

    void setSingleCertStat(int n, int n2, int n3, String string, int n4) {
        if (n2 == 0) {
            this.status = new int[n];
            this.revDate = new String[n];
            this.reason = new int[n];
        }
        this.status[n2] = n3;
        if (n3 == 1) {
            this.revDate[n2] = string;
            this.reason[n2] = n4;
        }
    }

    private native int _processResMsg(byte[] var1, byte[] var2);

    private native int _verify(byte[] var1, byte[] var2);
}

