/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.pkcs;

import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class Pkcs5 {
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public byte[] encrypt(PrivateKey privateKey, String string, String string2) throws GpkiApiException {
        if (privateKey == null) {
            throw new GpkiApiException("The priKey is empty. You must input a value for it.");
        }
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The passwd is empty. You must input a value for it.");
        }
        if (string2 == null || string2.length() == 0) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        int n = Algorithm.getSecretKeyAlg(string2);
        if (this.gpkiapi.PRIKEY_Encrypt(Algorithm.code2id(n), string, privateKey.getKey()) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public PrivateKey decrypt(byte[] byArray, String string) throws GpkiApiException {
        if (byArray == null || byArray.length == 0) {
            throw new GpkiApiException("The encPriKey is empty. You must input a value for it.");
        }
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The passwd is empty. You must input a value for it.");
        }
        if (this.gpkiapi.PRIKEY_Decrypt(string, byArray) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        PrivateKey privateKey = new PrivateKey(this.gpkiapi.baReturnArray);
        return privateKey;
    }
}

