/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.storage;

import com.gpki.gpkiapi.cert.X509Certificate;
import com.gpki.gpkiapi.crypto.Algorithm;
import com.gpki.gpkiapi.crypto.PrivateKey;
import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class SmartCard {
    public static int DATA_TYPE_GPKI_SIGN = 1;
    public static int DATA_TYPE_GPKI_KM = 2;
    public static int DATA_TYPE_NPKI_SIGN = 16;
    public static int DATA_TYPE_NPKI_KM = 32;
    private String libPath = "";
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public SmartCard(String string) {
        this.libPath = string;
        this.gpkiapi.STORAGE_SetLibraryPath(string);
    }

    public X509Certificate readCert(int n, String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The pin is empty. You must input a value for it.");
        }
        if (this.gpkiapi.STORAGE_ReadCert(gpkiapi_jni.MEDIA_TYPE_DYNAMIC, string, n) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        X509Certificate x509Certificate = new X509Certificate(this.gpkiapi.baReturnArray);
        return x509Certificate;
    }

    public void writeCert(int n, String string, X509Certificate x509Certificate) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The pin is empty. You must input a value for it.");
        }
        if (x509Certificate == null) {
            throw new GpkiApiException("The cert is empty. You must input a value for it.");
        }
        if (this.gpkiapi.STORAGE_WriteCert(gpkiapi_jni.MEDIA_TYPE_DYNAMIC, string, n, x509Certificate.getCert()) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public void deleteCert(int n, String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The pin is empty. You must input a value for it.");
        }
        if (this.gpkiapi.STORAGE_DeleteCert(gpkiapi_jni.MEDIA_TYPE_DYNAMIC, string, n) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public PrivateKey readPriKey(int n, String string, String string2) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The pin is empty. You must input a value for it.");
        }
        if (this.gpkiapi.STORAGE_ReadPriKey(gpkiapi_jni.MEDIA_TYPE_DYNAMIC, string, string2, n) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        PrivateKey privateKey = new PrivateKey(this.gpkiapi.baReturnArray);
        return privateKey;
    }

    public void writePriKey(int n, String string, String string2, String string3, PrivateKey privateKey) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The pin is empty. You must input a value for it.");
        }
        if (string2 != null && string2.length() != 0 && (string3 == null || string3.length() == 0)) {
            throw new GpkiApiException("The algorithm is empty. You must input a value for it.");
        }
        if (privateKey == null) {
            throw new GpkiApiException("The prikey is empty. You must input a value for it.");
        }
        int n2 = Algorithm.getSecretKeyAlg(string3);
        if (this.gpkiapi.STORAGE_WritePriKey(gpkiapi_jni.MEDIA_TYPE_DYNAMIC, string, string2, n, Algorithm.code2id(n2), privateKey.getKey()) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }

    public void deletePriKey(int n, String string, String string2) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The pin is empty. You must input a value for it.");
        }
        if (this.gpkiapi.STORAGE_DeletePriKey(gpkiapi_jni.MEDIA_TYPE_DYNAMIC, string, string2, n) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
    }
}

