/*
 * Decompiled with CFR 0.152.
 */
package com.gpki.gpkiapi.util;

import com.gpki.gpkiapi.exception.GpkiApiException;
import com.gpki.gpkiapi_jni;

public class Ldap {
    public static final int DATA_TYPE_CA_CERT = 1;
    public static final int DATA_TYPE_SIGN_CERT = 2;
    public static final int DATA_TYPE_KM_CERT = 3;
    public static final int DATA_TYPE_ARL = 5;
    public static final int DATA_TYPE_CRL = 6;
    public static final int DATA_TYPE_DELTA_CRL = 7;
    public static final int DATA_TYPE_CTL = 8;
    public static final int DATA_TYPE_GPKI_WCERT = 9;
    private String ldapIP = "";
    private int ldapPort = 0;
    private String dnBuff = "";
    private byte[] errBuff;
    private String confFile = "";
    private byte[] dataBuff = null;
    private gpkiapi_jni gpkiapi = new gpkiapi_jni();

    public void setConfFile(String string) throws GpkiApiException {
        if (string == null || string.length() == 0) {
            throw new GpkiApiException("The confFilePath is empty. You must input a value for it.");
        }
        this.confFile = string;
        this.gpkiapi.API_SetConfFile(string);
    }

    public void setLdap(String string, int n) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The ip is empty. You must input a value for it.");
        }
        if (n == 0) {
            throw new GpkiApiException("The port is empty. You must input a value for it.");
        }
        this.ldapIP = string;
        this.ldapPort = n;
    }

    public byte[] getData(int n, String string) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The dn is empty. You must input a value for it.");
        }
        int n2 = 0;
        switch (n) {
            case 1: {
                n2 = gpkiapi_jni.LDAP_DATA_CA_CERT;
                break;
            }
            case 2: {
                n2 = gpkiapi_jni.LDAP_DATA_SIGN_CERT;
                break;
            }
            case 3: {
                n2 = gpkiapi_jni.LDAP_DATA_KM_CERT;
                break;
            }
            case 5: {
                n2 = gpkiapi_jni.LDAP_DATA_ARL;
                break;
            }
            case 6: {
                n2 = gpkiapi_jni.LDAP_DATA_CRL;
                break;
            }
            case 7: {
                n2 = gpkiapi_jni.LDAP_DATA_DELTA_CRL;
                break;
            }
            case 8: {
                n2 = gpkiapi_jni.LDAP_DATA_CTL;
                break;
            }
            case 9: {
                n2 = gpkiapi_jni.LDAP_DATA_GPKI_WCERT;
                break;
            }
            default: {
                throw new GpkiApiException("Unknwon type selected.");
            }
        }
        String string2 = "ldap://" + this.ldapIP + ":" + this.ldapPort + "/" + string;
        if (this.gpkiapi.LDAP_GetDataByURL(n2, string2) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public byte[] getData(String string, String string2) throws GpkiApiException {
        if (string2.length() == 0) {
            throw new GpkiApiException("The dn is empty. You must input a value for it.");
        }
        String string3 = "ldap://" + this.ldapIP + ":" + this.ldapPort + "/" + string2;
        if (this.gpkiapi.LDAP_GetAnyDataByURL(string, string3) > 0) {
            throw new GpkiApiException(this.gpkiapi.sDetailErrorString);
        }
        return this.gpkiapi.baReturnArray;
    }

    public void searchCN(int n, String string) throws GpkiApiException {
        if (string.length() == 0) {
            throw new GpkiApiException("The cn is empty. You must input a value for it.");
        }
        if (this._getDataByCN(this.ldapIP, this.ldapPort, n, string) > 0) {
            throw new GpkiApiException(this.gpkiapi.byteArray2String(this.errBuff));
        }
    }

    public byte[] getData() throws GpkiApiException {
        if (this.dataBuff == null || this.dataBuff.length == 0) {
            throw new GpkiApiException("First, use searchCN method.");
        }
        return this.dataBuff;
    }

    public String getDN() throws GpkiApiException {
        if (this.dnBuff.length() == 0) {
            throw new GpkiApiException("First, use searchCN method.");
        }
        return this.dnBuff;
    }

    private native int _getDataByCN(String var1, int var2, int var3, String var4);
}

