/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps;

import com.diquest.ir.common.database.entity.CollectionAuthoritySet;
import com.diquest.ir.common.database.entity.Member;
import com.diquest.ir.common.database.handler.AuthorityDB;
import com.diquest.ir.util.rdbms.ConnectionFactory;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

public class AccountUtil {
    public static StringBuffer help = new StringBuffer();
    public static final String SUPERUSER = "super";
    public static final String SUPERUSER_PASSWD = "1111";

    static {
        help.append("========================================================================\n");
        help.append("AccountUtil : Utility for Mariner3 Management Tool Account\n");
        help.append("[TYPE]\n");
        help.append("Type : 1, 2\n");
        help.append("\t1 - Set 'super' member password to initial password(1111).\n");
        help.append("\t2 - Clear all Connection Infos and Initialize.\n");
        help.append("========================================================================\n");
    }

    public static void initAccount() {
        System.out.println("[AccountUtil] Initialize Account Info...");
        Connection conn = null;
        try {
            System.out.print("[AccountUtil] Set 'super' member password to initial password...");
            conn = ConnectionFactory.getConnection();
            AuthorityDB auth = new AuthorityDB();
            Member superMember = auth.getMember(conn, SUPERUSER);
            if (superMember == null) {
                long current = System.currentTimeMillis();
                CollectionAuthoritySet collectionAuth = new CollectionAuthoritySet();
                auth.pushMember(conn, SUPERUSER, SUPERUSER, SUPERUSER_PASSWD, 'A', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', 'W', collectionAuth, "Ir Administrator", current, current);
            } else {
                long current = System.currentTimeMillis();
                auth.updateMember(conn, superMember.getUserID(), superMember.getName(), SUPERUSER_PASSWD, superMember.getAuthReportMng(), superMember.getAuthIndexMng(), superMember.getAuthSearchProfileMng(), superMember.getAuthThesaurusDicMng(), superMember.getAuthStopwordDicMng(), superMember.getAuthUserDicMng(), superMember.getAuthUserCnDicMng(), superMember.getAuthBannedwordDicMng(), superMember.getAuthRedirectDicMng(), superMember.getAuthRecommendDicMng(), superMember.getAuthCategoryRankDicMng(), superMember.getAuthDocumentRankDicMng(), superMember.getAuthKeywordProfileDicMng(), superMember.getAuthIndexLogMng(), superMember.getAuthErrorLogMng(), superMember.getAuthSearchLogMng(), superMember.getAuthJobLogMng(), superMember.getAuthCollectionMng(), superMember.getAuthServerMng(), superMember.getAuthLogSettingMng(), superMember.getAuthErrorReportMng(), superMember.getAuthJobListMng(), superMember.getAuthPopKeywordMng(), superMember.getAuthAccountMng(), superMember.getAuthConnectMng(), superMember.getAuthManagerToolMng(), superMember.getCollectionAuth(), superMember.getDescription(), superMember.getCreated().getTime(), current);
            }
            System.out.println("done.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void initConnection() {
        System.out.println("[AccountUtil] Initialize Connection Info...");
        Connection conn = null;
        try {
            System.out.print("[AccountUtil] Clear all infos of client table...");
            conn = ConnectionFactory.getConnection();
            AuthorityDB auth = new AuthorityDB();
            auth.removeAllClient(conn);
            System.out.println("done.");
            System.out.print("[AccountUtil] Insert localhost info...");
            long current = System.currentTimeMillis();
            auth.pushTrustedClient(conn, "127.0.0.1", "localhost", SUPERUSER, current);
            System.out.println("done.");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("[AccountUtil] Not Enough Arguments.");
            System.out.println(help.toString());
            System.exit(-1);
        }
        int type = Integer.parseInt(args[0]);
        System.out.println("[AccountUtil] start...");
        switch (type) {
            case 1: {
                AccountUtil.initAccount();
                break;
            }
            case 2: {
                AccountUtil.initConnection();
                break;
            }
        }
        System.out.println("[AccountUtil] end...");
    }
}

