/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.exception.IRException;
import com.diquest.ir.common.msg.ext.body.index.AddDocT;
import com.diquest.ir.common.msg.ext.body.index.DelDocT;
import com.diquest.ir.util.common.FileUtil;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.StringT;
import java.io.BufferedReader;
import java.util.StringTokenizer;

public class IndexTaskCommander {
    private final String ip;
    private final int port;
    private final String collection;
    public static StringBuffer help;

    public IndexTaskCommander(String ip, int port, String collection) {
        help = new StringBuffer();
        help.append("IndexTaskCommander : Register index task for each type.\n");
        help.append("[IP] [Port] [CollectionID] [type] (option)(-file filename)\n\n");
        help.append("IP : Destination server IP address\n");
        help.append("Port : Destination server port number\n");
        help.append("CollectionID : ID of collection to index\n");
        help.append("type : Index type(FULL, INC, UPDATE, ADDDOC, DELDOC, REBUILD)\n");
        help.append("option : If type is ADDDOC or DELDOC, document IDs to be add or delete. (ex : 123,523,132,9)\n");
        help.append("dbwatcher : If type is ADDDOC and using DBwatcher, DBWatcher ID must be here. ");
        help.append("-file filename : If type is ADDDOC or DELDOC, filename contains document IDs. (File content is document ID for each line.)\n\n");
        help.append("<Notice>\n");
        help.append("Each task does not execute in this process but register to server. Server must be alive.\n");
        this.ip = ip;
        this.port = port;
        this.collection = collection;
    }

    public int fullIndex() throws IRException {
        StringT requestData = new StringT(this.collection);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageIndexBuildAll", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public int rebuild() throws IRException {
        StringT requestData = new StringT(this.collection);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageIndexRebuild", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public int incIndex() throws IRException {
        StringT requestData = new StringT(this.collection);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageIndexBuildAdd", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public int updateIndex() throws IRException {
        StringT requestData = new StringT(this.collection);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageIndexBuildUpdate", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public int addDocIndex(String[] addDocIDs) throws IRException {
        AddDocT requestData = new AddDocT(this.collection, addDocIDs);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageDocumentAdd", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public int addDocIndex(String[] addDocIDs, String dbWatcherID) throws IRException {
        AddDocT requestData = new AddDocT(this.collection, addDocIDs, dbWatcherID);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageDocumentAdd", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public int delDocIndex(String[] delDocIDs) throws IRException {
        DelDocT requestData = new DelDocT(this.collection, delDocIDs);
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.management.index.ExtMessageDocumentDel", (Transmitable)requestData);
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        if (response == null) {
            return -2;
        }
        return response.getErrorCode();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println("Not enough arguments.\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        String collectionID = args[2];
        String cmdType = args[3];
        if (!(cmdType.equalsIgnoreCase("FULL") || cmdType.equalsIgnoreCase("REBUILD") || cmdType.equalsIgnoreCase("INC") || cmdType.equalsIgnoreCase("UPDATE") || cmdType.equalsIgnoreCase("ADDDOC") || cmdType.equalsIgnoreCase("DELDOC") || cmdType.equalsIgnoreCase("REBUILD"))) {
            System.out.println("Unknown type : " + cmdType + "\n");
            System.out.println(help.toString());
            System.exit(-1);
        }
        String[] docIDs = null;
        String dbWatcherID = "";
        if (cmdType.equalsIgnoreCase("ADDDOC") || cmdType.equalsIgnoreCase("DELDOC")) {
            if (args.length < 5) {
                System.out.println("Option(document ID list) does not exist.\n");
                System.out.println(help.toString());
                System.exit(-1);
            }
            if (args[4].equalsIgnoreCase("-FILE")) {
                if (args.length < 6) {
                    System.out.println("filename omitted.\n");
                    System.out.println(help.toString());
                    System.exit(-1);
                }
                StringBuffer docIDList = new StringBuffer();
                int lineNum = 0;
                try {
                    BufferedReader br = FileUtil.getBufferedReader((String)args[5]);
                    try {
                        String str;
                        while ((str = br.readLine()) != null) {
                            ++lineNum;
                            if (str.length() <= 0) continue;
                            docIDList.append(docIDList).append(',');
                            str = "";
                        }
                    }
                    finally {
                        br.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                docIDs = IndexTaskCommander.listToStringArray(docIDList.toString());
            } else {
                docIDs = IndexTaskCommander.listToStringArray(args[4]);
            }
            if (cmdType.equalsIgnoreCase("ADDDOC")) {
                dbWatcherID = args[4].equalsIgnoreCase("-FILE") ? (args.length == 7 ? args[6] : "") : (args.length == 6 ? args[5] : "");
            }
        }
        System.out.println("start...");
        try {
            IndexTaskCommander commander = new IndexTaskCommander(ip, port, collectionID);
            int success = 0;
            if (cmdType.equalsIgnoreCase("FULL")) {
                success = commander.fullIndex();
            } else if (cmdType.equalsIgnoreCase("REBUILD")) {
                success = commander.rebuild();
            } else if (cmdType.equalsIgnoreCase("INC")) {
                success = commander.incIndex();
            } else if (cmdType.equalsIgnoreCase("UPDATE")) {
                success = commander.updateIndex();
            } else if (cmdType.equalsIgnoreCase("ADDDOC")) {
                success = commander.addDocIndex(docIDs, dbWatcherID);
            } else if (cmdType.equalsIgnoreCase("DELDOC")) {
                success = commander.delDocIndex(docIDs);
            }
            if (success > 0) {
                System.out.println("[" + cmdType + "] Task is registered.");
            } else if (success == -1) {
                System.out.println("[" + cmdType + "] Cannot register task.");
            } else if (success == -2) {
                System.out.println("[" + cmdType + "] Cannot connect to server.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("end...");
    }

    private static String[] listToStringArray(String list) {
        StringTokenizer tokenizer = new StringTokenizer(list, ",");
        int countTokens = tokenizer.countTokens();
        String[] array = new String[countTokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String trimmedToken = tokenizer.nextToken().trim();
            if (trimmedToken.length() <= 0) continue;
            array[i++] = trimmedToken;
        }
        if (i != countTokens) {
            String[] copy = new String[i];
            System.arraycopy(array, 0, copy, 0, i);
            array = copy;
        }
        return array;
    }
}

