/*
 * Decompiled with CFR 0.152.
 */
package com.diquest.ir.client.apps;

import com.diquest.ir.client.network.ExternalClientPool;
import com.diquest.ir.common.TaskMonitorKey;
import com.diquest.ir.util.msg.Transmitable;
import com.diquest.ir.util.msg.external.ExtRequest;
import com.diquest.ir.util.msg.external.ExtResponse;
import com.diquest.ir.util.msg.type.ByteT;
import com.diquest.ir.util.msg.type.StringT;

public class TaskMonitorControl {
    private final String ip;
    private final int port;
    private final int cmdType;

    public TaskMonitorControl(String ip, int port, int cmdType) {
        this.ip = ip;
        this.port = port;
        this.cmdType = cmdType;
    }

    public void checkMonitor(String taskName) {
        System.out.println("[TaskMonitorControl] Start...");
        if (taskName == null) {
            System.out.println("TaskName is null.");
            System.exit(-1);
        }
        if (taskName.equals("") || taskName.length() == 0) {
            System.out.println("TaskName is empty.");
            System.exit(-1);
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageGetTaskMonitor", (Transmitable)new StringT(taskName));
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        ByteT statusT = (ByteT)response.getData();
        System.out.println("[TaskMonitorControl] Check monitor : " + taskName + " is " + TaskMonitorKey.statusToString((byte)statusT.value));
        System.out.println("[TaskMonitorControl] End...");
    }

    public void setMonitor(String taskName, int status) {
        System.out.println("[TaskMonitorControl] Start...");
        if (taskName == null) {
            System.out.println("TaskName is null.");
            System.exit(-1);
        }
        if (taskName.equals("") || taskName.length() == 0) {
            System.out.println("TaskName is empty.");
            System.exit(-1);
        }
        if (status < 1 || status > 3) {
            System.out.println("Illegal status number. (must be 1/2/3) ");
            System.exit(-1);
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageSetTaskMonitor", (Transmitable)new TaskMonitorKey(taskName, (byte)status));
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        System.out.println("[TaskMonitorControl] Set monitor : " + taskName + " is " + TaskMonitorKey.statusToString((byte)((byte)status)));
        System.out.println("[TaskMonitorControl] End...");
    }

    public void removeMonitor(String taskName) {
        System.out.println("[TaskMonitorControl] Start...");
        if (taskName == null) {
            System.out.println("TaskName is null.");
            System.exit(-1);
        }
        if (taskName.equals("") || taskName.length() == 0) {
            System.out.println("TaskName is empty.");
            System.exit(-1);
        }
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageRemoveTaskMonitor", (Transmitable)new StringT(taskName));
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        System.out.println("[TaskMonitorControl] Remove monitor : " + taskName);
        System.out.println("[TaskMonitorControl] End...");
    }

    public void removeAllMonitor() {
        System.out.println("[TaskMonitorControl] Start...");
        ExtRequest request = new ExtRequest("com.diquest.ir.server.msg.taskmonitor.ExtMessageRemoveAllTaskMonitor");
        ExtResponse response = ExternalClientPool.getInstance(this.ip, this.port).invoke(request);
        System.out.println("[TaskMonitorControl] Remove All monitor.");
        System.out.println("[TaskMonitorControl] End...");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Not enough argument!! \n");
            System.exit(-1);
        }
        String ip = args[0];
        int port = Integer.parseInt(args[1]);
        int cmdType = Integer.parseInt(args[2]);
        if ((1 > cmdType || cmdType > 4) && cmdType != 99) {
            System.out.println("Illegal command type : " + cmdType + "\n");
            System.exit(-1);
        }
        TaskMonitorControl control = new TaskMonitorControl(ip, port, cmdType);
        switch (cmdType) {
            case 1: {
                if (args.length < 4) {
                    System.out.println("Not enough argument!! \n");
                    System.exit(-1);
                }
                String taskName = args[3];
                control.checkMonitor(taskName);
                break;
            }
            case 2: {
                if (args.length < 5) {
                    System.out.println("Not enough argument!! \n");
                    System.exit(-1);
                }
                String taskName = args[3];
                int status = Integer.parseInt(args[4]);
                control.setMonitor(taskName, status);
                break;
            }
            case 3: {
                if (args.length < 4) {
                    System.out.println("Not enough argument!! \n");
                    System.exit(-1);
                }
                String taskName = args[3];
                control.removeMonitor(taskName);
                break;
            }
            case 4: {
                control.removeAllMonitor();
                break;
            }
            case 99: {
                control.removeMonitor("SearchProfile_DB_JOB");
                break;
            }
        }
    }
}

